unit uGlobal;

interface

uses
   Windows, Messages, Dib256, SysUtils, Classes;

const
   FILEBALLFIELD     = 'Field.Bmp';
   FILEDATASHOCK     = 'Shock.dat';

   FIELDWIDTH        = 600;
   FIELDHEIGHT       = 400;

   // Pads
   FILEDATAPAD       = 'Pad.dat';
   PADSPRITESNUMBER  = 10;
   PADCICLESPERSPRITE= 3;
   PADWIDTH          = 16;
   PADHEIGHT         = 40;
   PADINITPOSX       = 20;
   PADLIMY           = 10;

   // Ball
   FILEDATABALL      = 'Ball.dat';
   BALLWIDTH         = 16;
   BALLHEIGHT        = 16;
   BALLLIMY          = 12;
   BALLATRITO:Single = 0.01;
   BALLMINVEL:Single = 1;
   BALLMAXVEL:Single = 16;
   BALLINITPOSX      = 100;

   FIELDOUTTERLIMX   = 2;
   FIELDINNERLIMX    = (FIELDWIDTH - BALLWIDTH - 16) div 2;

   KEY_PAUSE         = 'P';
   KEY_EXIT          = 'Q';

   MOUSEDIFLIM_X     = 20;
   MOUSEDIFLIM_Y     = 20;

   NUM_CICLOS        = 20;

   SMWIDTH           = BALLWIDTH+PADWIDTH-1;    // shock mask width
   SMHEIGHT          = BALLHEIGHT+PADHEIGHT-1;  // shock mask height

   // Messages ID
   NB_GAMEWAITING    = 1;
   NB_NOGAME         = 2;
   NB_JOINGAME       = 3;
   NB_CONFIRMPLAYER  = 4;
   NB_QUERYGAMES     = 5;

   NBG_RESUMEGAME    = 1;
   NBG_PAUSEGAME     = 2;
   NBG_PADPOS        = 3;
   NBG_PADBALLPOS    = 4;
   NBG_ABORTGAME     = 5;
   NBG_SYSTEMREADY   = 6;
   NBG_STARTGAME     = 7;
   NBG_CONNECT       = 8;

   CONNECTION_TIMEOUT= 10000;
   STARTGAME_TIMEOUT = 10000;
   READ_TIMEOUT      = 10000;
   PLAYERNAMELENGTH  = 15;

   WM_ENDGAME        = WM_USER;
   WM_CLOSEMODAL     = WM_USER+1;
   END_OK            = 1;
   END_TIMEOUT       = 2;

type
   TPlayMode = ( Setup, Ready, Start, Play, Pause, Quit );

   // Messages structures
   Tnb_gamewaiting = record
      ID: byte;
      SenderID: DWord;
      PlayerName: array [0..PLAYERNAMELENGTH] of char;
      ComputerName: array [0..32] of char;
   end;
   Pnb_gamewaiting = ^Tnb_gamewaiting;
   Tnb_nogame = record
      ID: byte;
      SenderID: DWord;
   end;
   Pnb_nogame = ^Tnb_nogame;
   Tnb_joingame = record
      ID: byte;
      SenderID: DWord;
      PlayerName: array [0..PLAYERNAMELENGTH] of char;
      ComputerName: array [0..32] of char;
   end;
   Pnb_joingame = ^Tnb_joingame;
   Tnb_confirmplayer = record
      ID: byte;
      SenderID: DWord;
      PlayerName: array [0..PLAYERNAMELENGTH] of char;
      ComputerName: array [0..32] of char;
      Duration: Byte;
      Shock: Byte;
      SenderSide: Byte;
   end;
   Pnb_confirmplayer = ^Tnb_confirmplayer;

   Tnbg_resumegame = record
      ID: byte;
      SenderID: DWord;
   end;
   Pnbg_resumegame = ^Tnbg_resumegame;
   Tnbg_pausegame = record
      ID: byte;
      SenderID: DWord;
   end;
   Pnbg_pausegame = ^Tnbg_pausegame;
   Tnbg_padpos = record
      ID: byte;
      SenderID: DWord;
      CycleNum: DWord;
      PadX: Word;
      PadY: Word;
   end;
   Pnbg_padpos = ^Tnbg_padpos;
   Tnbg_padballpos = record
      ID: byte;
      SenderID: DWord;
      CycleNum: DWord;
      PadX: Word;
      PadY: Word;
      BallX: Word;
      BallY: Word;
      BallVel, BallAng: Single;
   end;
   Pnbg_padballpos = ^Tnbg_padballpos;
   Tnbg_abortgame = record
      ID: byte;
      SenderID: DWord;
   end;
   Pnbg_abortgame = ^Tnbg_abortgame;
   Tnbg_systemready = record
      ID: byte;
      SenderID: DWord;
   end;
   Pnbg_systemready = ^Tnbg_systemready;
   Tnbg_startgame = record
      ID: byte;
      SenderID: DWord;
   end;
   Pnbg_startgame = ^Tnbg_startgame;
   Tnbg_connect = record
      ID: byte;
      SenderID: DWord;
   end;
   Pnbg_connect = ^Tnbg_connect;

   TPad = record
      PosX, PosY: Single;
      PosAntX, PosAntY: Longint;
      VelX, VelY: array [0..7] of LongInt;
      IndVel: Byte;
      IndSprite: Byte;
      PlayerName: array [0..PLAYERNAMELENGTH] of char;
      Goals: Integer;
   end;
   TBall = record
      PosX, PosY: Single;
      PosAntX, PosAntY: Longint;
      Vel, Ang: Single;
      Side: Byte;
   end;

   TPadSpriteStorage = array [0..PADWIDTH*PADHEIGHT-1] of char;
   TPadSprites = array [0..PADSPRITESNUMBER-1] of TPadSpriteStorage;
   TBallSprites = array [0..BALLWIDTH*BALLHEIGHT-1] of char;
   TShockMask = array [0..1,0..SMWIDTH-1,0..SMHEIGHT-1]
      of byte;


   procedure CartesianToPolar( X, Y: Single; var D, Ang: Single );
   procedure PolarToCartesian( D, Ang: Single; var X, Y: Single );

var
   DibField: TDib256;
   Pad: array [0..1] of TPad;
   PadSprites: array [0..1] of TPadSprites;
   Ball: TBall;
   BallSprites: TBallSprites;
   ShockMask: TShockMask;
   SelfID: DWord;
   OpponentID: DWord;
   OpponentComputerName: array [0..32] of char;
   PlayerSide: Byte;
   GameTimer: Integer;     // seconds
   ShockElasticity: Single;
   SelfCycle, OpponentCycle: Longint;
   OnePlayer: Boolean;

   FPM: TPlayMode;

implementation

procedure CartesianToPolar( X, Y: Single; var D, Ang: Single );
begin
   D := Sqrt(Sqr(X) + Sqr(Y));
   try
      if (X > 0) then
         Ang := arctan(Y/X)
      else
         Ang := arctan(Y/X)+Pi;
   except
      on EZeroDivide do Ang := 0;
      on EInvalidOp do Ang := 0;
   end;
end;


procedure PolarToCartesian( D, Ang: Single; var X, Y: Single );
begin
   X := D*cos(Ang);
   Y := D*sin(Ang);
end;


end.
