unit TestTerm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Mailslot;

type
  TfMain = class(TForm)
    Terminal: TMailslotTerminal;
    memoReceived: TMemo;
    radioReceiverType: TRadioGroup;
    editDomainOrComputer: TEdit;
    Label1: TLabel;
    editSendText: TEdit;
    Label2: TLabel;
    buttonSend: TButton;
    procedure radioReceiverTypeClick(Sender: TObject);
    procedure buttonSendClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure TerminalNewMessage(Sender: TObject; SenderId: Integer;
      MsgSize: Word);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fMain: TfMain;

implementation

{$R *.DFM}

procedure TfMain.radioReceiverTypeClick(Sender: TObject);
begin
   case radioReceiverType.ItemIndex of
      0: Terminal.Receiver := rcLocalComputer;
      1: Terminal.Receiver := rcDomainOrComputer;
      2: Terminal.Receiver := rcPrimaryDomain;
   end;

   if radioReceiverType.ItemIndex = 1 then
      editDomainOrComputer.Enabled := True
   else
      editDomainOrComputer.Enabled := False;
end;

procedure TfMain.buttonSendClick(Sender: TObject);
begin
   Terminal.ReceiverName := editDomainOrComputer.Text;

   with editSendText do
      Terminal.WriteMessage( PChar(Text)^, Length(Text)+1 );
end;

procedure TfMain.FormActivate(Sender: TObject);
begin
   radioReceiverType.ItemIndex := radioReceiverType.ItemIndex;
end;

procedure TfMain.TerminalNewMessage(Sender: TObject; SenderId: Integer;
  MsgSize: Word);
var
   st: string;
begin
   SetLength( st, MsgSize );
   Terminal.Message.Read( PChar(st)^, MsgSize );
   memoReceived.Lines.Add( st );
end;

end.
