unit PalAnim;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinGImag, ExtCtrls;

type
  TfPalAnimation = class(TForm)
    WI: TWinGImage;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure WIClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
      procedure VertLine( X, Y, H: Integer; Color: Byte );
      procedure DrawCilinder;
      procedure ScrollColors;
  end;

var
  fPalAnimation: TfPalAnimation;

implementation

{$R *.DFM}

procedure TfPalAnimation.FormCreate(Sender: TObject);
var
   Cnt: Integer;
begin
   // init. WinG size
   WI.WinG.Width := Width;
   WI.WinG.Height := Height;
   WI.Visible := True;

   // init. palette
   WI.Palette.Entries[10].peRed := 255;
   WI.Palette.Entries[10].peBlue := 255;
   WI.Palette.Entries[10].peGreen := 255;
   WI.Palette.Entries[10].peFlags := 1;
   for Cnt := 0 to 200 do
   begin
      WI.Palette.Entries[Cnt+20].peRed := Cnt;
      WI.Palette.Entries[Cnt+20].peBlue := 200-Cnt;
      WI.Palette.Entries[Cnt+20].peGreen := 64;
      WI.Palette.Entries[Cnt+20].peFlags := 1;
   end;
   WI.Palette.CreateHandle;

   // cover background
   for Cnt := 0 to WI.WinG.WidthBytes*WI.WinG.Height do
      (WI.WinG.Pixels+Cnt)^ := Chr(10);

   DrawCilinder;

   TextOut( WI.WinG.Handle, 10, 200, 'Click to start/stop animation', 29 );
end;


procedure TfPalAnimation.DrawCilinder;
var
   Cnt, H: Integer;
   RX, RY, CX, CY: Single;
begin
   RX := 80;
   RY := 50;
   H := 70;
   CX := 100;
   CY := 60;

   for Cnt := 0 to 1000 do
   begin
      VertLine( Trunc(CX+RX*cos(Cnt*2*PI/1000)),
         Trunc(CY-RY*sin(Cnt*2*PI/1000)), H, (Cnt div 5)+20 );
   end;
end;


procedure TfPalAnimation.VertLine( X, Y, H: Integer; Color: Byte );
var
   Cnt, LnAdd: Integer;
   pt: PChar;
begin
   LnAdd := WI.WinG.WidthBytes;
   pt := WI.WinG.Pixels + Y*LnAdd + X;
   for Cnt := 1 to H do
   begin
      pt^ := Chr(Color);
      Inc(pt, LnAdd);
   end;
end;


procedure TfPalAnimation.ScrollColors;
var
   Cnt: Integer;
begin
   for Cnt := 20 to 220 do
      WI.Palette.Entries[Cnt-1] := WI.Palette.Entries[Cnt];
   WI.Palette.Entries[220] := WI.Palette.Entries[19];

   WI.Palette.Animate(20, 201);
end;


procedure TfPalAnimation.WIClick(Sender: TObject);
begin
   Timer1.Enabled := not(Timer1.Enabled);
end;


procedure TfPalAnimation.Timer1Timer(Sender: TObject);
begin
   ScrollColors;
end;

end.
