{A solution for getting all Subdirectories of a given Path}
{---------------------------------------------------------}

{Programmed in Borland Delphi's Object Pascal
   by Harald Fischer, Aug. 1996 / CIS 101551,105}
{Mail me if there are further questions}

{Goes recursive through all levels of a basepath and stores
 the SubDir-Names ascending in an array of PChars.}

{After calling "RecurseSubDir" from the main-program, all
 Subdirectories with its full Pathnames are stored in a list
 of PChars called SubDir[1] until SubDir[MAXSUBDIRCOUNT].
 To display them in a Memo for i.e. you can add a code
 to your application such as:
 for i := 1 to TotalSubDirCount do Memo1.Lines.Add(StrPas(SubDir[i]));}

uses SysUtils;

const MAXSUBDIRCOUNT = 15000;

var
  BasePath,SearchPath: string;
  SubDir: array[1..MAXSUBDIRCOUNT] of PChar;
  FindError, TotalSubDirCount, SubDirLevelCounter, TempTotalSubDirCount,
    CurrentSubDirLevelCount: integer;
  FileRec: TSearchRec;

procedure RecurseSubDir;
var
  i: Word;
begin
  CurrentSubDirLevelCount := SubDirLevelCounter;
  SubDirLevelCounter := 0;
  TempTotalSubDirCount := TotalSubDirCount;
  for i:=1 To CurrentSubDirLevelCount Do
    begin
      SearchPath := StrPas(SubDir[i + TempTotalSubDirCount - CurrentSubDirLevelCount]);
      {$I-} ChDir(SearchPath); FindError := IOResult; {$I+}
      if SearchPath[length(SearchPath)] <> '\' then SearchPath := SearchPath + '\';
      FindError := FindFirst(SearchPath + '*.*', $37, FileRec);
      while FindError = 0 do
      begin
        If (FileRec.Attr AND $10 = $10) And (FileRec.Name <> '.') And (FileRec.Name <> '..')  then
        begin
          SubDirLevelCounter := SubDirLevelCounter + 1;
          if TotalSubDirCount < MAXSUBDIRCOUNT then
            TotalSubDirCount := TotalSubDirCount + 1 else
          begin
            {Place a warning message that the number of max SubDirs has reached}
            FindClose(FileRec);
            Exit;
          end;
          GetMem(SubDir[TotalSubDirCount], length(SearchPath + FileRec.Name) + 1);
          StrPCopy(SubDir[TotalSubDirCount], SearchPath+FileRec.Name);
        End;
        FindError := FindNext(FileRec);
      end;
      FindClose(FileRec);
      {$I+} ChDir('..'); FindError := IOResult; {$I+}
    End;
  If SubDirLevelCounter <> 0 then RecurseSubDir;
end;

procedure SortSubDirs;  {Sorts the SubDir-List ascending}
var
  i,j: Word;
  TStr1,TStr2: string;
begin
  for i:= 1 to TotalSubDirCount do
  begin
    for j:= i to TotalSubDirCount do
    begin
      if UpperCase(StrPas(SubDir[j])) < UpperCase(StrPas(SubDir[i])) then
      begin
        TStr1 := StrPas(SubDir[j]); FreeMem(SubDir[j],length(TStr1)+1);
        TStr2 := StrPas(SubDir[i]); FreeMem(SubDir[i],length(TStr2)+1);
        GetMem(SubDir[j],length(TStr2)+1); StrPCopy(SubDir[j],TStr2);
        GetMem(SubDir[i],length(TStr1)+1); StrPCopy(SubDir[i],TStr1);
      end;
    end;
  end;
end;

begin
  BasePath := 'C:\';
  SubDirLevelCounter := 1;
  TotalSubDirCount := 1;
  GetMem(SubDir[TotalSubDirCount], length(BasePath) + 1);
  StrPCopy(SubDir[TotalSubDirCount], BasePath);
  RecurseSubDir;
  SortSubDirs;
end.

