unit Main;
{ This is a utility which takes an unsorted file and sorts it.  It was
  developed because I wanted a list of Object Pascal constants to use
  in a program.  Unfortunately, getting the constants from various .pas
  files meant the list would not be in alphabetical order.  To put them
  in alphabetical order so the user could easily find the constant value
  desire, this little program was developed.  It is freeware and has no
  warranty expressed or implied.

  Charles M. Fisher
  102444,534@Compuserve.com
  May 10, 1997

  }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    LoadBtn: TButton;
    ExitBtn: TButton;
    SaveBtn: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure LoadBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    List : TStringList;        // To get the contents of a file.
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  List := TStringList.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  List.free;
end;

procedure TForm1.LoadBtnClick(Sender: TObject);
var
  i : integer;
begin
if OpenDialog1.Execute then
  begin
    { Get all the values in sorted order, }
    List.sorted := true;
    List.duplicates := dupIgnore;
    List.LoadFromFile(OpenDialog1.FileName);
    { Display the alphabetized list. }
    for i := 0 to List.Count - 1 do
      Memo1.Lines.Add(List[i]);
    SaveDialog1.Filename := OpenDialog1.FileName;
  end;
end;

procedure TForm1.SaveBtnClick(Sender: TObject);
{ TMemo is limited to 1836 lines of text, whereas TStringList is not.  On
  the chance we have loaded a file that exceeds max lines, it is best
  to use the StringList to write to the file. }
begin
  if SaveDialog1.Execute then
    if List.Count > Memo1.Lines.Count then
      List.SaveToFile(SaveDialog1.FileName)
    else
      Memo1.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TForm1.ExitBtnClick(Sender: TObject);
begin
  Close;
end;

end.
