unit Stacks;
{This unit creates a stack which holds strings as its native type.  However,
 with standard conversion routines, it can hold other types as well.  See
 StackTest.pas for examples of converting popped strings to other native
 types.

 NOTE:  THIS UNIT CREATES A GLOBAL STACK in the way Delphi 2.0 creates a global
 Screen object.  You never need to create your own stack or destroy it.  Let
 this unit handle those details for you.

 Author:  Charles M. Fisher, 102444,534@Compuserve.com

 Freeware without warranty == Use at your own risk == January 3, 1997.
 }
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  EStackException = class(Exception);  // Our own exception object

type
  TStack = class(TStringList)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create;
    function StackEmpty: boolean;
    procedure push(const item: string);
    function  pop: string;
  published
    { Published declarations }
  end;
              
var
  Stack : TStack;

implementation

constructor TStack.Create;
begin
  inherited create;          // Get the stringList instantiated
  Sorted := false;
  duplicates := dupIgnore;
end;

function TStack.StackEmpty:boolean;
begin
  result := Stack.Count = 0;
end;
procedure TStack.push(const Item: string);
begin
  try
   Stack.Insert(0, Item); // to the "top" of the stack
  except
    raise EStackException.Create('Stack is full');
  end;
end;

function TStack.pop: string;
begin
  try
    // Get the "top" item from the stack...
    result := Stack.strings[0];
    // and now remove it.
    Stack.delete(0);
  except
    raise EStackException.Create('Stack is empty');
  end;
end;

initialization
  // create a global stack object to use anywhere in your program
  Stack := TStack.Create;
finalization
  Stack.free;
end.
