{ Component Create for Delphi }
{ Sample form for property editor - Double data type }

unit Edit_flt;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TFloatPropDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Edit1: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
      { Transfer buffer for property's value }
      Value : Double;
  end;

var
  FloatPropDlg: TFloatPropDlg;

implementation

{$R *.DFM}

procedure TFloatPropDlg.FormActivate(Sender: TObject);
var S : String;
begin
     Str(Value:1:2, S);
     Edit1.Text := S;
     Edit1.SelectAll
end;

procedure TFloatPropDlg.OKBtnClick(Sender: TObject);
var I : Integer;
begin
     Val(Edit1.Text, Value, I);
     if I <> 0 then
        ModalResult := mrCancel
     else
         ModalResult := mrOK
end;

end.
