{ Component Create for Delphi }
{ Sample form for property editor - Integer data type }

unit Edit_int;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Mask;

type
  TIntPropDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Edit1: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
      { Transfer buffer for property's value }
      Value : Integer;
  end;

var
  IntPropDlg: TIntPropDlg;

implementation

{$R *.DFM}

procedure TIntPropDlg.FormActivate(Sender: TObject);
var S : String;
begin
     Str(Value, S);
     Edit1.Text := S;
     Edit1.SelectAll
end;

procedure TIntPropDlg.OKBtnClick(Sender: TObject);
var I : Integer;
begin
     Val(Edit1.Text, Value, I);
     if I <> 0 then
        ModalResult := mrCancel
     else
         ModalResult := mrOK
end;

end.
