unit CyborgQA;
{main component unit}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, dsgnintf, cybabout, Cfrminfo;

type

  TCyborgQAEditor = class(TComponentEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  tCYBAboutParentInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

    tCYBTabInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

  tCYBParentInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

  tCYBHintedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

  tCYBDataInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

    tCYBMenuInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

  tCYBRePosnEdit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

  TCyborgQA = class(TCOMPONENT)
  protected
    { Protected declarations }
   Function GetAll : tcontrol;
   Procedure SetAll(AAll : tcontrol);
  published
    { Published declarations }
   Property About : tcontrol Read GetAll write setAll stored false;
   Property Parentage : tcontrol Read GetAll write setAll stored false;
   Property Hints : tcontrol Read GetAll write setAll stored false;
   Property Positions : tcontrol Read GetAll write setAll stored false;
   Property Tabs : tcontrol Read GetAll write setAll stored false;
   Property DataInfo : tcontrol Read GetAll Write SetAll stored false;
   Property MenuInfo : tcontrol Read GetAll Write SetAll stored false;
  end;

procedure register;

implementation

const
Aboutstr      =0;
DataInfostr   =1;
Hintsstr      =2;
MenuInfostr   =3;
Parentagestr  =4;
Positionsstr  =5;
Tabsstr       =6;
maxverbs = succ(Tabsstr);

Function tCyborgQA.GetAll : tcontrol;
Begin
   Result := (self.owner as tcontrol);
End;

Procedure tCyborgQA.SetAll(AAll : tcontrol);
Begin
End;

procedure tCYBAboutParentInfoedit.Edit;

begin
   CYBorgQAAbout;
end;

procedure tCYBParentInfoedit.Edit;

begin
   showparentage(tcontrol(getordvalue));
end;

procedure tCYBHintedit.Edit;

begin
   showHints(tcontrol(getordvalue));
end;

procedure tCYBRePosnEdit.Edit;

begin
   reposition(tcontrol(getordvalue));
end;

procedure tCYBTabInfoedit.Edit;
begin
   showalltabs(tcontrol(getordvalue));
end;

procedure tCYBDataInfoedit.Edit;
begin
   showDataRelations(tcontrol(getordvalue));
end;

procedure tCYBMenuInfoedit.Edit;
begin
   showMenus(tcontrol(getordvalue));
end;

procedure TCyborgQAEditor.ExecuteVerb(Index: Integer);
begin
   Case Index of
         Aboutstr        :      CYBorgQAAbout;
         Parentagestr    :      showparentage(tcontrol(Component.owner));
         Hintsstr        :      showHints(tcontrol(Component.owner));
         Positionsstr    :      reposition(tcontrol(Component.owner));
         Tabsstr         :      showalltabs(tcontrol(Component.owner));
         DataInfostr     :      showDataRelations(tcontrol(Component.owner));
         MenuInfostr     :      showMenus(tcontrol(Component.owner));
   end;
end;

function TCyborgQAEditor.GetVerb(Index: Integer): string;
begin
   Case Index of
      Aboutstr         :   result := 'About';
      Parentagestr     :   result := 'Parentage';
      Hintsstr         :   result := 'Hints';
      Positionsstr     :   result := 'Positions';
      Tabsstr          :   result := 'Tabs';
      DataInfostr      :   result := 'DataInfo';
      MenuInfostr      :   result := 'MenuInfo';
   end;
end;

function TCyborgQAEditor.GetVerbCount: Integer;

begin
   result := maxverbs;
end;

procedure register;

begin
   RegisterComponents('Cyborg', [tCyborgQA]);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'About', tCYBAboutParentInfoedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'Parentage', tCYBParentInfoedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'Hints', tCYBHintedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'DataInfo', tCYBDataInfoedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'Positions', tCYBRePosnEdit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'Tabs', tCYBTabInfoedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgQA, 'MenuInfo', tCYBMenuInfoedit);
   RegisterComponentEditor(tCyborgQA, TCyborgQAEditor);
end;

end.
