Unit Ext_IDE;

{***********************************************************}
{                                                           }
{   Extended IDE                                            }
{   Do not include this file in your project.               }
{   It's only of any use in Delphi's IDE or                 }
{   Borland C++Builder's IDE. Install Ext_IDE as a          }
{   component. It makes sub-properties                      }
{   (starting with a "+") in the Objectinspector            }
{   available by a keypress of the "+" or Return key.       }
{   Form now on you don't have to double click with the     } 
{   mouse on them.                                          }
{                                                           }
{   Date:    May, 17 1997                                   }
{   Version: 1.2                                            }
{   System: Delphi 2, Delphi 3, Borland C++Builder          }
{   Author:  Jan - M. Strube                                }
{                                                           }
{   http://ourworld.compuserve.com/homepages/praxisservice/ }
{                                                           }
{                                                           }
{***********************************************************}

interface

procedure Register;

implementation

uses
  Windows, Messages, SysUtils, Classes, Forms;

function Keypressed_at_Anywhere(Key: WParam; Shift: TShiftState): Boolean;
var
  Eat_Key: Boolean;
begin
  Eat_Key:= False;  // do not eat the key by default


  // Single Key pressed
  if (Shift = []) or (Shift = [ssShift]) then
    Case Key Of
      VK_F10: ;
    End;


  // Ctrl Key pressed
  if ssCtrl in Shift then
    Case Key Of
      ord('0'): ;
      ord('1'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
      VK_F2: ;
      VK_F3: ;
      VK_F5: ;
      VK_F6: ;
      VK_F10: ;
      VK_F11: ;
    End;


  // Alt Key pressed
  if ssAlt in Shift then
    Case Key Of
      ord('1'): ;
      ord('2'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
      VK_F1: ;
      VK_F2: ;
      VK_F5: ;
      VK_F7: ;
      VK_F8: ;
      VK_F9: ;
      VK_F11: ;
      VK_F12: ;
    End;

  Keypressed_at_Anywhere:= Eat_Key;
end;

function GetObjInspListBox(WinHndle: HWnd; lPar: LongInt): BOOL; stdcall;
var
  CurrentClass: Array[0..100] of Char;
begin
  CurrentClass[0]:= #0;
  GetClassName(WinHndle, CurrentClass, sizeOf(CurrentClass)-1);
  if StrIComp(CurrentClass, 'TPropListBox') = 0 then begin
    {we found the ListBox of Objectinspector}
    PLongInt(lPar)^:= WinHndle;
    GetObjInspListBox:= False;
  end else
    GetObjInspListBox:= True;
end;

function Keypressed_at_ObjectInspector(Key: WParam; Shift: TShiftState): Boolean;
var
  Eat_Key: Boolean;
  ObjInspListHandle: LongInt;
  CurrentSel: Integer;
  CurrentItemRect: TRect;
begin
  Eat_Key:= False;  // do not eat the key by default


  // Single Key pressed at Objectinspector
  if (Shift = []) or (Shift = [ssShift]) then begin
    if Key in [VK_ADD, VK_SUBTRACT, VKKeyScan('+'), VKKeyScan('-'), VK_RETURN] then begin
      ObjInspListHandle:= 0;
      EnumChildWindows(GetActiveWindow, @GetObjInspListBox, LongInt(@ObjInspListHandle));
      if ObjInspListHandle <> 0 then begin
        CurrentSel:= SendMessage(ObjInspListHandle, LB_GETCURSEL, 0, 0);
        if CurrentSel <> LB_ERR then
          if SendMessage(ObjInspListHandle, LB_GETITEMRECT, CurrentSel,
                         LongInt(@CurrentItemRect)) <> LB_ERR then
            SendMessage(ObjInspListHandle, WM_LBUTTONDBLCLK, MK_LBUTTON,
                        MakeLong(CurrentItemRect.Left, CurrentItemRect.Top));
      end;
    end;
  end;


  // Ctrl Key pressed at Objectinspector
  if ssCtrl in Shift then
    Case Key Of
      ord('0'): ;
      ord('1'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
      VK_F2: ;
      VK_F3: ;
      VK_F5: ;
      VK_F6: ;
      VK_F10: ;
      VK_F11: ;
    End;


  // Alt Key pressed at Objectinspector
  if ssAlt in Shift then
    Case Key Of
      ord('1'): ;
      ord('2'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
      VK_F1: ;
      VK_F2: ;
      VK_F5: ;
      VK_F7: ;
      VK_F8: ;
      VK_F9: ;
      VK_F11: ;
      VK_F12: ;
    End;

  Keypressed_at_ObjectInspector:= Eat_Key;
end;

function Keypressed_at_EditWindow(Key: WParam; Shift: TShiftState): Boolean;
var
  Eat_Key: Boolean;
begin
  Eat_Key:= False;  // do not eat the key by default

  // Single Key pressed at EditWindow
  if (Shift = []) or (Shift = [ssShift]) then
    Case Key Of
      ord('0'): ;
      ord('1'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
    End;

  // Ctrl Key pressed at EditWindow
  if ssCtrl in Shift then
    Case Key Of
      ord('0'): ;
      ord('1'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
      VK_F2: ;
      VK_F3: ;
      VK_F5: ;
      VK_F6: ;
      VK_F10: ;
      VK_F11: ;
    End;

  // Alt Key pressed at EditWindow
  if ssAlt in Shift then
    Case Key Of
      ord('1'): ;
      ord('2'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
      VK_F1: ;
      VK_F2: ;
      VK_F5: ;
      VK_F7: ;
      VK_F8: ;
      VK_F9: ;
      VK_F11: ;
      VK_F12: ;
    End;

  Keypressed_at_EditWindow:= Eat_Key;
end;

function Keypressed_at_MenuWindow(Key: WParam; Shift: TShiftState): Boolean;
var
  Eat_Key: Boolean;
begin
  Eat_Key:= False;  // do not eat the key by default


  // Single Key pressed at MenuWindow
  if (Shift = []) or (Shift = [ssShift]) then
    Case Key Of
      ord('0'): ;
      ord('1'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
    End;

  // Ctrl Key pressed at MenuWindow
  if ssCtrl in Shift then
    Case Key Of
      ord('0'): ;
      ord('1'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
      VK_F2: ;
      VK_F3: ;
      VK_F5: ;
      VK_F6: ;
      VK_F10: ;
      VK_F11: ;
    End;

  // Alt Key pressed at MenuWindow
  if ssAlt in Shift then
    Case Key Of
      ord('1'): ;
      ord('2'): ;
      {...}
      ord('Y'): ;
      ord('Z'): ;
      VK_F1: ;
      VK_F2: ;
      VK_F5: ;
      VK_F7: ;
      VK_F8: ;
      VK_F9: ;
      VK_F11: ;
      VK_F12: ;
    End;

  Keypressed_at_MenuWindow:= Eat_Key;
end;


{----------------------------------------------------------------------------------------------
                  KeyBoard - Filter
-----------------------------------------------------------------------------------------------}
var
  ExtIDE_KBDHookHandle: HHook;

function KeyBoardHookProc(nCode: Integer; Charcode: WPARAM; KeyData: LPARAM): DWORD;
stdcall;
var
  CurrentWindowClass: Array[0..100] of Char;
  EatTheKey: Boolean;
  CurrentShiftState: TShiftState;
Begin
  if (nCode < 0) or (nCode <> HC_ACTION) then begin
    KeyBoardHookProc:= CallNextHookEx(ExtIDE_KBDHookHandle, nCode, CharCode, KeyData);
    Exit;
  End;

  {(lParam and $80000000) = 0 ,wenn Taste gedrckt wurde
   (lParam and $80000000) <> 0 ,wenn Taste losgelassen wurde}
  if (KeyData and $80000000) <> 0 then begin
    KeyBoardHookProc:= CallNextHookEx(ExtIDE_KBDHookHandle, 0, Charcode, KeyData);
    Exit;
  end;

  CurrentShiftState:= KeyDataToShiftState(KeyData);
  EatTheKey:= Keypressed_at_Anywhere(CharCode, CurrentShiftState);

  if not EatTheKey and (GetClassName(GetActiveWindow, CurrentWindowClass,
                                     sizeOf(CurrentWindowClass)-1) > 0) then begin
    if StrIComp(CurrentWindowClass, 'TPropertyInspector') = 0 then
      Keypressed_at_ObjectInspector(CharCode, CurrentShiftState)
    else if StrIComp(CurrentWindowClass, 'TEditWindow') = 0 then
      Keypressed_at_EditWindow(CharCode, CurrentShiftState)
    else if StrIComp(CurrentWindowClass, 'TAppBuilder') = 0 then
      Keypressed_at_MenuWindow(CharCode, CurrentShiftState);
  end;

  if not EatTheKey then
    {put Key into the system queue again}
    KeyBoardHookProc:= CallNextHookEx(ExtIDE_KBDHookHandle, 0, CharCode, KeyData)
  else
    KeyBoardHookProc:= 1;
End;

procedure Register;
begin
  // no component to register
end;

var
  CurrProgram: Array[0..255] of Char;

initialization
  ExtIDE_KBDHookHandle:= 0;
  CurrProgram[0]:= #0;
  GetModuleFileName(hInstance, CurrProgram, sizeOf(CurrProgram)-1);
  {loaded into IDE?}
  if (UpperCase(ExtractFileExt(CurrProgram)) = '.DCL') or // Delphi 2
     (UpperCase(ExtractFileExt(CurrProgram)) = '.DPL') or // Delphi 3
     (UpperCase(ExtractFileExt(CurrProgram)) = '.CCL') then // C++Builder 1
    ExtIDE_KBDHookHandle:= SetWindowsHookEx(wh_KeyBoard, TFNHookProc(@KeyBoardHookProc),
                                          0, GetCurrentThreadId);
finalization
  {remove Keyboard-Hook if Delphi shuts down}
  if (ExtIDE_KBDHookHandle <> 0) then
    UnHookWindowsHookEx(ExtIDE_KBDHookHandle);
End.
