unit Demofrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Ezq, DB, DBTables, Grids, DBGrids, Menus;

type
  TfmDemo = class(TForm)
    MainMenu1: TMainMenu;
    Query1: TMenuItem;
    DefineQuery1: TMenuItem;
    N1: TMenuItem;
    ClearQuery1: TMenuItem;
    N2: TMenuItem;
    LoadQuery1: TMenuItem;
    SaveQuery1: TMenuItem;
    Exit1: TMenuItem;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Query: TQuery;
    EZQuery1: TEZQuery;
    procedure DefineQuery1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ClearQuery1Click(Sender: TObject);
    procedure LoadQuery1Click(Sender: TObject);
    procedure SaveQuery1Click(Sender: TObject);
  private
    { Private declarations }
  public
    procedure PerformQuery;
  end;

var
  fmDemo: TfmDemo;

implementation

{$R *.DFM}

procedure TfmDemo.PerformQuery;

begin
  Screen.Cursor := crHourglass; Application.ProcessMessages;
  try
    Query.SQL.Clear;
    Query.SQL.Assign(EZQuery1.SQL);
    Query.Open;
  finally
    Screen.Cursor := crDefault; Application.ProcessMessages;
  end;
end;

procedure TfmDemo.DefineQuery1Click(Sender: TObject);
begin
  if EZQuery1.Execute then
  begin
    if MessageDlg('Would you like to perform the query now?', mtConfirmation,
                  [mbYes,mbNo],0) = mrYes then
      PerformQuery;
  end;
end;

procedure TfmDemo.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TfmDemo.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := MessageDlg('Are you sure you want to exit the demo?', mtConfirmation,
                         [mbYes,mbNo],0) = mrYes;
end;

procedure TfmDemo.ClearQuery1Click(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to clear the current query?', mtConfirmation,
                [mbYes,mbNo],0) = mrYes then
    EZQuery1.ClearQuery;
end;

procedure TfmDemo.LoadQuery1Click(Sender: TObject);
begin
  if EZQuery1.LoadQuery('') {use current directory as default} then
    MessageDlg('Query loaded!', mtInformation,[mbOk],0)
  else
    MessageDlg('Query not loaded!', mtInformation, [mbOk],0);
end;

procedure TfmDemo.SaveQuery1Click(Sender: TObject);
begin
  if EZQuery1.SaveQuery('') {use current directory as default} then
    MessageDlg('Query saved!', mtInformation,[mbOk],0)
  else
    MessageDlg('Query not saved!', mtInformation, [mbOk],0);
end;

end.
