unit Tgeticon;

interface
uses Shellapi,Sysutils,classes,wintypes,Winprocs,Graphics;
Type TExeIcon=class(Tobject)
 private
  FBitMap:Tbitmap;
  FIcon:TIcon;
 Protected

 Public
  Function    IconCount(Filename:String):Integer;
  Function    IconAtIndex(Filename:String;IDX:Integer):TBitmap;
  Function    DefaultIcon(Filename:String):TBitmap;
  constructor Create;
  Destructor  Destroy;override;

End;

implementation
Function TexeIcon.IconCount(Filename:String):Integer;
Var
 lpszFilename:array[0..254] of char;
 H:THandle;
 IDX:Word;
begin
 StrPCopy(lpszFilename,Filename);
 IDX:=WORD(-1);
 Result:= ExtractIcon(HINSTANCE,lpszFilename,IDX);
end;


Function  TexeIcon.IconAtIndex(Filename:String;IDX:Integer):TBitmap;
Var
 lpszFilename:array[0..254] of char;
 H:THandle;
begin
 StrPCopy(lpszFilename,Filename);
 H:= ExtractIcon(HINSTANCE,lpszFilename,IDX);
 FIcon.Handle:= CopyIcon(Hinstance,H);
 FbitMap.Width:=32;
 Fbitmap.Height:=32;
 Fbitmap.Canvas.Fillrect(Rect(0,0,32,32));
 FBitmap.Canvas.Draw(0,0,FIcon);
 Result:=Fbitmap;
end;

Function TexeIcon.DefaultIcon(Filename:String):TBitmap;
Var
 lpszFilename:array[0..254] of char;
 H:THandle;
 IDX:Word;
begin
 StrPCopy(lpszFilename,Filename);
 IDX:=0;
 H:= ExtractIcon(HINSTANCE,lpszFilename,IDX);
 FIcon.Handle:= CopyIcon(Hinstance,H);
 FbitMap.Width:=32;
 Fbitmap.Height:=32;
 Fbitmap.Canvas.Fillrect(Rect(0,0,32,32));
 FBitmap.Canvas.Draw(0,0,FIcon);
 Result:=Fbitmap;
end;

constructor TExeIcon.Create;
Begin
 Fbitmap:=Tbitmap.create;
 Fbitmap.width:=32;
 Fbitmap.Height:=32;
 FIcon:=Ticon.create;
End;

Destructor TExeIcon.Destroy;
Begin
 Fbitmap.free;
 FIcon.Free;
End;

end.
