{******************************************************}
{             rsRFMRec V2.6  (for rsRFM)               }
{        Copyright 1997 RealSoft Development           }
{           support:  www.realsoftdev.com              }
{******************************************************}

unit rsRfmrec;

interface

uses Graphics;

type
        TDrawType    =  (rfNone, rfUnused, rfText, rfFrame, rfLine, rfCkBox, rfField,
                         rfEllipse, rfRoundRect);
        TLineType    =  (ltHorz, ltVert, ltDiagL, ltDiagR);
        TFillStyle   =  (fsClear, fsSolid, fsDiagonal, fsHash);
        TPaperSize   =  (psLegal, psLetter, psA3, psA4, psA5);
        TOrientation =  (orPortrait, orLandScape);
        TFieldFormat =  (ffText,ffCheckBox,ffDropList,ffInteger,ffReal,ffDollar,ffPhone,
                         ffDate,ffTime,ffCustom1,ffCustom2,ffCustom3,ffCustom4,ffCustom5,
                         ffCustom6,ffCustom7,ffCustom8);

        {----------Header Data----------}
        RFormHdr = packed record
          NumRecs               : smallint;
          PaperSize             : TPaperSize;
          Thick                 : byte;
          PStyle                : TPenStyle;
          Width                 : Word;
          Height                : Word;
          VersionMajor          : byte;
          VersionMinor          : byte;
          Orientation           : TOrientation;
          Unused                : array[0..86] of byte;
          end;

        {----------Object Data----------}
        RFormRec = packed record
          DrawType               : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          StrIdx1               : word;
          StrIdx2               : word;
          unused                : array[0..11] of byte;
        end;

        RFormText = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          StrIdx                : word;
          FontIdx               : word;
          FontStyle             : TFontStyles;
          FontSize              : byte;
          Color                 : byte;
          Vert                  : byte;
          FontHt                : smallint;
          unused                : array[0..5] of byte;
          end;

        RFormFrame = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          PStyle                : TPenStyle;
          FStyle                : TFillStyle;
          Color                 : byte;
          LColor                : byte;
          Thick                 : byte;
          unused                : array[0..10] of byte;
          end;

        RFormLine = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          PStyle                : TPenStyle;
          LType                 : TLineType;
          Color                 : byte;
          Thick                 : byte;
          unused                : array[0..11] of byte;
          end;

        RFormCkBox = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          Color                 : byte;
          Thick                 : byte;
          unused                : array[0..13] of byte;
          end;

        RFormEllipse = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          PStyle                : TPenStyle;
          FStyle                : TFillStyle;
          Color                 : byte;
          LColor                : byte;
          Thick                 : byte;
          unused                : array[0..10] of byte;
          end;

        RFormRoundRect = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          PStyle                : TPenStyle;
          FStyle                : TFillStyle;
          Color                 : byte;
          LColor                : byte;
          Thick                 : byte;
          Corner                : smallint;
          unused                : array[0..8] of byte;
          end;

        {-----------Field Data----------}
        RFormField = packed record
          DrawType              : TDrawType;
          Left                  : smallint;
          Top                   : smallint;
          Width                 : word;
          Height                : word;
          StrIdx                : word;
          FontIdx               : word;
          FontStyle             : TFontStyles;
          FontSize              : byte;
          Color                 : byte;
          Vert                  : byte;
          Format                : TFieldFormat;
          FontHt                : smallint;
          DatLen                : byte;
          unused                : array[0..3] of byte;
          end;

        RRFLField = packed record
          Ver                   : byte;
          Left                  : smallint;
          Top                   : smallint;
          Name                  : String[20];
          FontName              : String[32];
          FontStyle             : TFontStyles;
          FontSize              : byte;
          FontColor             : byte;
          FontHt                : smallint;
          Format                : TFieldFormat;
          DatLen                : byte;
          Vert                  : byte;
          unused                : array[0..4] of byte;
          end;

implementation

end.
