unit CSimCoP;

{
	Sim(ple)Co(mmand)P(rocessor)
  Component

  Autor:
  Thomas Schubbauer, Juni 1997
  MCW Ges.m.b.H.
  Breuninggasse 6
  A-1230 Wien
  alle Rechte vorbehalten
}

interface

uses
  SysUtils,
  Classes,
  SimCoP;

type
  TCSimCoP = class (TComponent)
    private
      Running   : Boolean;
      FSimCoP   : TSimCoP;
      FProcName : String;

      function  GetFastMode : Boolean;
      procedure SetFastMode (Value : Boolean);
      function  GetUserCommands : TStrings;
      procedure SetUserCommands (Value : TStrings);
      function  GetDoMessages : Integer;
      procedure SetDoMessages (Value : Integer);
      function  GetSource : TStrings;
      procedure SetSource (Value : TStrings);
      function  GetSourcePath : String;
      procedure SetSourcePath (Value : String);
      function  GetOnError : TErrorProc;
      procedure SetOnError (Value : TErrorProc);
      function  GetOnCommand : TCommandProc;
      procedure SetOnCommand (Value : TCommandProc);
      function  GetOnLoad : TLoadProc;
      procedure SetOnLoad  (Value : TLoadProc);

    public
      constructor Create (AOwner : TComponent); override;
      destructor	Destroy; override;

      procedure Run;
      procedure	Load (const cProgram : TFileName);

      property  SimCoP      : TSimCoP
        read    FSimCoP;

    published
      property  ProcName    : String
        read    FProcName
        write   FProcName;
      property	FastMode 		: Boolean
      	read		GetFastMode
        write		SetFastMode;
			property	UserCommands: TStrings
      	read		GetUserCommands
        write   SetUserCommands;
      property	DoMessages 	: Integer
      	read		GetDoMessages
        write		SetDoMessages;
      property	Source			: TStrings
      	read		GetSource
        write   SetSource;
      property	SourcePath	: TFileName
      	read		GetSourcePath
        write		SetSourcePath;
      property	OnLoad 			: TLoadProc
      	read		GetOnLoad
        write		SetOnLoad;
      property 	OnCommand		: TCommandProc
      	read		GetOnCommand
        write		SetOnCommand;
      property	OnError			: TErrorProc
      	read		GetOnError
        write		SetOnError;

  end;


procedure Register;

implementation

constructor TCSimCoP.Create (AOwner : TComponent);
begin
  inherited Create (AOwner);
  FSimCoP := TSimCoP.Create;
end;

destructor TCSimCoP.Destroy;
begin
  FSimCoP.Destroy;
  inherited Destroy;
end;


function  TCSimCoP.GetFastMode : Boolean;
begin
  Result := FSimCoP.FastMode;
end;

procedure TCSimCoP.SetFastMode (Value : Boolean);
begin
  FSimCoP.FastMode := Value;
end;

function  TCSimCoP.GetUserCommands : TStrings;
begin
  Result := FSimCoP.UserCommands;
end;

procedure TCSimCoP.SetUserCommands (Value : TStrings);
begin
  FSimCoP.UserCommands.Assign (Value);
end;

function  TCSimCoP.GetDoMessages : Integer;
begin
  Result := FSimCoP.DoMessages;
end;

procedure TCSimCoP.SetDoMessages (Value : Integer);
begin
  FSimCoP.DoMessages := Value;
end;


function  TCSimCoP.GetSource : TStrings;
begin
  Result := FSimCoP.Source;
end;

procedure TCSimCoP.SetSource (Value : TStrings);
begin
  FSimCoP.Source.Assign (Value);
end;

function  TCSimCoP.GetSourcePath : String;
begin
  Result := FSimCoP.SourcePath;
end;

procedure TCSimCoP.SetSourcePath (Value : String);
begin
  FSimCoP.SourcePath := Value;
end;

function  TCSimCoP.GetOnError : TErrorProc;
begin
  Result := FSimCoP.OnError;
end;

procedure TCSimCoP.SetOnError (Value : TErrorProc);
begin
  FSimCoP.OnError := Value;
end;

function  TCSimCoP.GetOnCommand : TCommandProc;
begin
  Result := FSimCoP.OnCommand;
end;

procedure TCSimCoP.SetOnCommand (Value : TCommandProc);
begin
  FSimCoP.OnCommand := Value;
end;

function  TCSimCoP.GetOnLoad : TLoadProc;
begin
  Result := FSimCoP.OnLoad;
end;

procedure TCSimCoP.SetOnLoad (Value : TLoadProc);
begin
  FSimCoP.OnLoad := Value;
end;

procedure TCSimCoP.Run;
begin
  if not Running then begin
    Running := True;
    try
      FSimCoP.Execute (FProcName, [Unassigned]);
    finally
      Running := False;
    end;
  end;
end;

procedure	TCSimCoP.Load (const cProgram : TFileName);
begin
  if not Running then FSimCoP.Load (cProgram);
end;

procedure Register;
begin
  RegisterComponents ('SimCoP', [TCSimCoP]);
end;

end.
