unit FSimIDE;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, ComCtrls, Funcs, Menus, SimCoP, SimExpr, SimDlg,
  SimTable, SimOle;

const
	fmNone			= 0;
	fmFind			= 1;
  fmReplace 	= 2;
	TabStops		= 2;
  ProtocolLen	= 200;
  UM_AutoMarg = WM_User + $100;

type
  TSimIDE = class(TForm)
    ToolBar: TPanel;
    btnFileNew: TSpeedButton;
    btnFileOpen: TSpeedButton;
    btnFileExit: TSpeedButton;
    btnProgramStart: TSpeedButton;
    btnFileSave: TSpeedButton;
    MainMenu: TMainMenu;
    menFile: TMenuItem;
    menProgram: TMenuItem;
    menFileNew: TMenuItem;
    menFileSave: TMenuItem;
    menFileOpen: TMenuItem;
    menFileSaveAs: TMenuItem;
    menFileExit: TMenuItem;
    N1: TMenuItem;
    menProgramStart: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    menProgramClearOutput: TMenuItem;
    btnProgramClearOutput: TSpeedButton;
    PnlSource: TPanel;
    Output: TMemo;
    Source: TMemo;
    Status: TStatusBar;
    menProgramProtocol: TMenuItem;
    menEdit: TMenuItem;
    menEditInsert: TMenuItem;
    menEditCopy: TMenuItem;
    menEditCut: TMenuItem;
    FindDialog: TFindDialog;
    ReplaceDialog: TReplaceDialog;
    menEditFind: TMenuItem;
    menEditReplace: TMenuItem;
    menEditFindNext: TMenuItem;
    N2: TMenuItem;
    menProgramStop: TMenuItem;
    BtnDemoGraf: TButton;
    BtnDemoGame: TButton;
    BtnDemoTable: TButton;
    menHelp: TMenuItem;
    menHelpHelp: TMenuItem;
    BtnDemoOle: TButton;
    BtnDemoCalculator: TButton;
    txtDemo: TLabel;
    procedure SourceMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure menFileNewClick(Sender: TObject);
    procedure SourceChange(Sender: TObject);
    procedure menFileOpenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure menFileSaveClick(Sender: TObject);
    procedure menFileSaveAsClick(Sender: TObject);
    procedure menFileExitClick(Sender: TObject);
    procedure OutputChange(Sender: TObject);
    procedure menProgramClearOutputClick(Sender: TObject);
    procedure menProgramStartClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure menProgramProtocolClick(Sender: TObject);
    procedure menEditCutClick(Sender: TObject);
    procedure menEditCopyClick(Sender: TObject);
    procedure menEditInsertClick(Sender: TObject);
    procedure FindDialogFind(Sender: TObject);
    procedure menEditFindClick(Sender: TObject);
    procedure menEditFindNextClick(Sender: TObject);
    procedure menEditReplaceClick(Sender: TObject);
    procedure ReplaceDialogFind(Sender: TObject);
    procedure ReplaceDialogReplace(Sender: TObject);
    procedure menProgramStopClick(Sender: TObject);
    procedure BtnDemoGrafClick(Sender: TObject);
    procedure BtnDemoGameClick(Sender: TObject);
    procedure SourceKeyPress(Sender: TObject; var Key: Char);
    procedure SourceKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BtnDemoTableClick(Sender: TObject);
    procedure menHelpClick(Sender: TObject);
    procedure menHelpHelpClick(Sender: TObject);
    procedure BtnDemoOleClick(Sender: TObject);
    procedure BtnDemoCalculatorClick(Sender: TObject);
  private
    { Private-Deklarationen }
    nFindMode : Integer;
    lChanged	: Boolean;
		Row, Col 	: Integer;
    OutHeight : Integer;
    SimCoP		: TSimCoP;
    lHalted		: Boolean;
    procedure ShowStatus;
    procedure ShowStatusEx;
    procedure CursorPos;
    procedure SetCursorPos (nRow, nCol : Integer);
		procedure SetSelection (nRow1, nCol1, nRow2, nCol2 : Integer);
    procedure AutoMarg (var Msg); message UM_AutoMarg;
    function	CheckSave : Boolean;
    procedure Clear;
    procedure SaveFile;
    procedure SaveFileAs;
    procedure LoadFile;
    procedure	OnLoadFile (cProgram : TFileName; var Done : Boolean);
    procedure Protocol (s : String);
    procedure	Command (cCommand : String; var Done : Boolean);
    procedure Error (E : ESimCoPError);
    function	Find (cFind : String; lMatchCase, lMsg : Boolean) : Boolean;
  public
    { Public-Deklarationen }
    procedure ShowHeap;
    procedure Demo (cProgram : String);
  end;

var
  SimIDE: TSimIDE;

implementation

{$R *.DFM}

function VarAsString (v : Variant) : String;
begin
	case TVarData (v).VType of
   	varInteger, varSmallint :
    	Result := IntToStr (v);
    varBoolean :
    	if v = 0 then Result := 'False' else Result := 'True';
    varString, varOleStr :
    	Result := v;
    varSingle, varDouble, varCurrency :
    	Result := FloatToStr (v);
    varDate :
    	Result := DateToStr (v);
  else
  	Result := '???';
  end;

end;

procedure TSimIDE.CursorPos;
begin
  Row := Source.Perform (EM_LineFromChar, Source.SelStart, 0);
  Col := Source.SelStart - Source.Perform (EM_LineIndex, Row, 0);
end;

procedure TSimIDE.SetCursorPos (nRow, nCol : Integer);
var
	p : Integer;
begin
	p := Source.Perform (EM_LineIndex, nRow, 0) + nCol;
	Source.Perform (EM_SetSel, p, p);
  Source.Perform (EM_ScrollCaret, 0, 0);
  CursorPos;
  ShowStatus;
end;

procedure TSimIDE.SetSelection (nRow1, nCol1, nRow2, nCol2 : Integer);
var
	p1, p2 : Integer;
begin
	p1 := Source.Perform (EM_LineIndex, nRow1, 0) + nCol1;
  p2 := Source.Perform (EM_LineIndex, nRow2, 0) + nCol2;
	Source.Perform (EM_SetSel, p1, p2);
  Source.Perform (EM_ScrollCaret, 0, 0);
  CursorPos;
  ShowStatus;
end;

procedure TSimIDE.AutoMarg (var Msg);
var
	i, j : Integer;
begin
	Application.ProcessMessages;
  if not Empty (Source.Lines [Row]) then Exit;
	i := Row - 1;
  while i >= 0 do begin
    if not Empty (Source.Lines [i]) then break;
  	Dec (i);
  end;
  if i >= 0 then begin
  	j := 1;
    while Source.Lines [i][j] = ' ' do Inc (j);
    Source.Lines [Row] := Space (j - 1) + Source.Lines [Row];
    SetCursorPos (Row, j - 1);
  end;
end;

procedure TSimIDE.ShowStatusEx;
var
	cFile : String;
begin
	if Empty (OpenDialog.FileName) then
  	cFile := 'Unbenannt'
  else
  	cFile := OpenDialog.FileName;
	Self.Caption := 'SimCoP [' + AnsiUpperCase (cFile) + ']';
	ShowStatus;
end;

procedure TSimIDE.ShowStatus;
begin
	Status.Panels.Items[0].Text := IntToStr (Row + 1) + ' : ' + IntToStr (Col + 1);
 	if lChanged then
		Status.Panels.Items[1].Text := 'Gendert'
  else
		Status.Panels.Items[1].Text := ''
end;

procedure TSimIDE.SourceMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
	CursorPos;
  ShowStatus;
end;

procedure TSimIDE.SaveFileAs;
begin
	if SaveDialog.Execute then begin
    OpenDialog.FileName := SaveDialog.FileName;
  	SaveFile;
    ShowStatusEx;
  end;
end;

procedure TSimIDE.SaveFile;
begin
	Source.Lines.SaveToFile (SaveDialog.FileName);
  lChanged := False
end;

procedure TSimIDE.LoadFile;
begin
	if OpenDialog.Execute then begin
  	Source.Lines.LoadFromFile (OpenDialog.FileName);
    SaveDialog.FileName := OpenDialog.FileName;
    lChanged := False;
    CursorPos;
    ShowStatusEx;
  end;
end;

procedure TSimIDE.Clear;
begin
	OutputChange (self);
	Source.Clear;
  Source.Lines.Add ('function Main');
  Source.Lines.Add ('  ');
  Source.Lines.Add ('return');
  SetCursorPos (1, 2);
	lChanged 	:= False;
	OpenDialog.FileName := '';
  SaveDialog.FileName := '';
  ShowStatusEx;
end;

function TSimIDE.CheckSave : Boolean;
var
	Answer : Integer;
begin
	Result := not lChanged;
	while lChanged and not Result do begin
  	Answer := MessageDlg (
    						'Programm nicht gespeichert!' + #13 + 'Jetzt speichern?',
                mtConfirmation, [mbYes, mbNo, mbCancel], 0);
		case Answer of
    	mrYes :
      	begin
	        menFileSaveClick (self);
          Result := not lChanged;
        end;
      mrNo :
      	begin
        	Result := True;
        end;
      mrCancel :
      	begin
        	Result 		:= False;
          break;
        end;
    end;
  end;
end;

procedure TSimIDE.menFileNewClick(Sender: TObject);
begin
	if CheckSave then Clear;
end;

procedure TSimIDE.SourceChange(Sender: TObject);
begin
	lChanged := True;
end;

procedure TSimIDE.menFileOpenClick(Sender: TObject);
begin
  if CheckSave then LoadFile
end;

procedure TSimIDE.FormCreate(Sender: TObject);
begin
	SimCoP := TSimCoP.Create;
  SimCoP.OnError := Error;
  SimCoP.OnLoad	:= OnLoadFile;
  SimCoP.DoMessages := 10;
  SimDlg.SimRegister (SimCoP);
  SimOle.SimRegister (SimCoP);
  SimTable.SimRegister (SimCoP);
	OutHeight := Output.Height;
	Clear;
  nFindMode := fmNone;
end;

procedure TSimIDE.menFileSaveClick(Sender: TObject);
begin
	if Empty (SaveDialog.FileName) then
  	SaveFileAs
  else
		SaveFile;
end;

procedure TSimIDE.OnLoadFile (cProgram : TFileName; var Done : Boolean);
begin
	if Empty (cProgram) then begin
  	SimCoP.Source.Assign (Source.Lines);
    Done := True
  end;
end;

procedure TSimIDE.menFileSaveAsClick(Sender: TObject);
begin
	SaveFileAs
end;

procedure TSimIDE.menFileExitClick(Sender: TObject);
begin
	Close;
end;

procedure TSimIDE.OutputChange(Sender: TObject);
begin
	if Output.Lines.Count = 0 then
  	Output.Height := 0
  else if (Output.Lines.Count = 1) and Empty (Output.Lines.Strings [0]) then
  	Output.Height := 0
  else
  	Output.Height := OutHeight;
end;

procedure TSimIDE.menProgramClearOutputClick(Sender: TObject);
begin
	Output.Clear;
  OutputChange (self);
end;

procedure TSimIDE.menProgramStartClick(Sender: TObject);
var
	SimResult : Variant;
begin
	menProgramStart.Enabled := False;
	menProgramStop.Enabled 	:= True;
  btnProgramStart.Enabled := False;
  lHalted := False;
	try
    SimCoP.Load ('');
		{$ifdef DEBUG}
    	ShowHeap;
		{$endif}
    SimResult := SimCoP.Execute ('Main', [Unassigned]);
    if lHalted then
	    Protocol ('Programm abgebrochen')
    else begin
	    Protocol ('Programm erfolgreich beendet');
  	  Protocol ('  Ergebnis: ' + VarAsString (SimResult));
    end;
  except
  end;
	{$ifdef DEBUG}
  	ShowHeap;
	{$endif}
	menProgramStart.Enabled := True;
	menProgramStop.Enabled 	:= False;
  btnProgramStart.Enabled := True;
end;

procedure TSimIDE.FormDestroy(Sender: TObject);
begin
	SimCoP.Destroy;
end;

procedure TSimIDE.Protocol (s : String);
begin
	if Output.Lines.Count > ProtocolLen then
		Output.Lines.Delete (0);
	Output.Lines.Add (s);
end;

procedure TSimIDE.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	CanClose := CheckSave
end;

procedure	TSimIDE.Command (cCommand : String; var Done  : Boolean);
begin
	Protocol (Format ('%0:4d %s', [SimCoP.FuncLine, cCommand]));
end;

procedure TSimIDE.menProgramProtocolClick(Sender: TObject);
begin
	menProgramProtocol.Checked := not menProgramProtocol.Checked;
  if menProgramProtocol.Checked then
	  SimCoP.OnCommand := Command
  else
	  SimCoP.OnCommand := nil;
end;


procedure TSimIDE.Error (E : ESimCoPError);
begin

  MessageBeep (mb_IconHand);
  Protocol ('*** Programmfehler ***');
  Protocol (E.Message);
  Protocol ('Func ' + SimCoP.FuncName + ' Zeile ' + IntToStr (SimCoP.FuncLine));
  SetCursorPos (SimCoP.FuncLine - 1, 0);

  if E.ErrorSource is TExpParser then
	with E.ErrorSource as TExpParser do begin
  	Protocol (Expression);
    Protocol (Space (ParsePos - 1) + '^')
 	end;

end;

procedure TSimIDE.menEditCutClick(Sender: TObject);
begin
	Source.CutToClipboard
end;

procedure TSimIDE.menEditCopyClick(Sender: TObject);
begin
	Source.CopyToClipboard
end;

procedure TSimIDE.menEditInsertClick(Sender: TObject);
begin
	Source.PasteFromClipboard
end;

function TSimIDE.Find (cFind : String; lMatchCase, lMsg : Boolean) : Boolean;
var
	r, c, p				: Integer;
  Point					: TPoint;
  FRect, RRect 	: TRect;
begin
	r := Row;
  c := Col + 2;
  p := 0;
  if not lMatchCase then cFind := AnsiUpperCase (cFind);
  with Source.Lines do begin
	  while r < Count do begin
    	if lMatchCase then
	    	p := Pos (cFind, Copy (Strings [r], c, MaxInt))
      else
	    	p := Pos (cFind, AnsiUpperCase (Copy (Strings [r], c, MaxInt)));
			if p > 0 then Break;
      Inc (r);
      c := 1;
    end;
  end;
  Result := p > 0;
  if p > 0 then begin
  	SetSelection (r, c + p - 2, r, c + p - 2 + Length (cFind));
  	GetWindowRect (FindDialog.Handle, FRect);
  	GetWindowRect (ReplaceDialog.Handle, RRect);
    with Point do begin
      x := Source.Perform (EM_POSFROMCHAR, Source.SelStart, 0);
      y := x shr 16;
      x := x and $FFFF;
      Point := Source.ClientToScreen (Point);
      if x > Screen.Width div 2 then begin
        FindDialog.Left 	:= x - (FRect.Right - FRect.Left) + 20;
        ReplaceDialog.Left:= x - (RRect.Right - RRect.Left) + 20;
      end else begin
        FindDialog.Left 	:= x;
        ReplaceDialog.Left:= x;
      end;
      if y > Screen.Height div 2 then begin
        FindDialog.Top 		:= y - (FRect.Bottom - FRect.Top);
        ReplaceDialog.Top	:= y - (RRect.Bottom - RRect.Top);
      end else begin
        FindDialog.Top 		:= y + 20;
        ReplaceDialog.Top	:= y + 20;
      end;
    end;
  end else if lMsg then ShowMessage (cFind + ' nicht gefunden');
end;

procedure TSimIDE.FindDialogFind(Sender: TObject);
begin
 	nFindMode := fmFind;
  Find (FindDialog.FindText, frMatchCase in FindDialog.Options, True);
end;

procedure TSimIDE.menEditFindClick(Sender: TObject);
begin
	FindDialog.Position	:= Source.ClientToScreen (Point (Source.Left, Source.Top));
	FindDialog.Execute
end;

procedure TSimIDE.menEditFindNextClick(Sender: TObject);
begin
	ReplaceDialog.FindText := FindDialog.FindText;
  if frMatchCase in FindDialog.Options then
  	ReplaceDialog.Options := ReplaceDialog.Options + [frMatchCase]
  else
  	ReplaceDialog.Options := ReplaceDialog.Options - [frMatchCase];
	Find (FindDialog.FindText, frMatchCase in FindDialog.Options, True);
end;

procedure TSimIDE.menEditReplaceClick(Sender: TObject);
begin
	ReplaceDialog.Position := Source.ClientToScreen (Point (Source.Left, Source.Top));
	ReplaceDialog.Execute
end;

procedure TSimIDE.ReplaceDialogFind(Sender: TObject);
begin
	FindDialog.FindText := ReplaceDialog.FindText;
  if frMatchCase in ReplaceDialog.Options then
  	FindDialog.Options := FindDialog.Options + [frMatchCase]
  else
  	FindDialog.Options := FindDialog.Options - [frMatchCase];
  Find (ReplaceDialog.FindText, frMatchCase in ReplaceDialog.Options, True);
end;

procedure TSimIDE.ReplaceDialogReplace(Sender: TObject);
var
	cmp 	: Boolean;
  Count : Integer;
begin
	FindDialog.FindText := ReplaceDialog.FindText;
  if frMatchCase in ReplaceDialog.Options then
  	FindDialog.Options := FindDialog.Options + [frMatchCase]
  else
  	FindDialog.Options := FindDialog.Options - [frMatchCase];
  if frMatchCase in ReplaceDialog.Options then
  	cmp := AnsiCompareStr (Source.SelText, ReplaceDialog.FindText) = 0
  else
  	cmp := AnsiCompareText (Source.SelText, ReplaceDialog.FindText) = 0;
  if not cmp then
  	if not Find (ReplaceDialog.FindText, frMatchCase in ReplaceDialog.Options, True) then
    	Exit;
  Count := 0;
  if (frReplace in ReplaceDialog.Options) or (frReplaceAll in ReplaceDialog.Options) then begin
		repeat
    	Inc (Count);
    	Source.ClearSelection;
      Source.Lines [Row] := Copy (Source.Lines [Row], 1, Col) +
														ReplaceDialog.ReplaceText +
                            Copy (Source.Lines [Row], Col + 1, MaxInt);
			SetCursorPos (Row, Col + Length (ReplaceDialog.ReplaceText) - 1);
    	if not Find (ReplaceDialog.FindText, frMatchCase in ReplaceDialog.Options, False) then Break;
    until not (frReplaceAll in ReplaceDialog.Options);
	end;
  if (frReplaceAll in ReplaceDialog.Options) then
  	Showmessage (Format ('%0:d Ersetzungen durchgefhrt.', [Count]));
end;

procedure TSimIDE.menProgramStopClick(Sender: TObject);
begin
	lHalted := True;
	SimCoP.Halt
end;

procedure TSimIDE.BtnDemoGrafClick(Sender: TObject);
begin
  Demo ('Graph')
end;

procedure TSimIDE.BtnDemoGameClick(Sender: TObject);
begin
  Demo ('Game')
end;

procedure TSimIDE.BtnDemoTableClick(Sender: TObject);
begin
  Demo ('Table')
end;

procedure TSimIDE.BtnDemoOleClick(Sender: TObject);
begin
  Demo ('OLE')
end;

procedure TSimIDE.BtnDemoCalculatorClick(Sender: TObject);
begin
  Demo ('Calc')
end;

procedure TSimIDE.Demo (cProgram : String);
begin
	if CheckSave then begin
		OpenDialog.FileName	:= cProgram + '.sim';
	  SaveDialog.FileName := OpenDialog.FileName;
		Source.Lines.LoadFromFile (OpenDialog.FileName);
		lChanged := False;
	  menProgramStartClick (Self);
  end;
end;

procedure TSimIDE.SourceKeyPress(Sender: TObject; var Key: Char);
var
	NewCol : Integer;
begin
  case Key of
    #9 	:
      begin
        CursorPos;
        NewCol := Col + (Col mod TabStops) + TabStops;
        Source.Lines [Row] :=
          Pad (Copy (Source.Lines [Row], 1, Col), NewCol) +
          Copy (Source.Lines [Row], Col + 1, MaxInt);
        SetCursorPos (Row, NewCol);
        Key := #0;
      end;
  end;
	CursorPos;
  ShowStatus;
end;

procedure TSimIDE.SourceKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
	if (Shift = []) and (Key = vk_Return) then begin
    Postmessage (self.Handle, UM_AutoMarg, 0, 0);
  end;
 	CursorPos;
  ShowStatus;
end;

procedure TSimIDE.ShowHeap;
const
	act : Integer = 0;
  min : Integer = 0;
  max : Integer = 0;
  last : Integer = 0;
var
	Heap : THeapStatus;
begin

	Heap := GetHeapStatus;
  last := act;
  act := Heap.TotalAllocated;

  if act > max then
  	max := act;
	if (act < min) or (min = 0) then
  	min := act;

  Protocol (Format ('Akt%0:6d Overh%1:6d Zul%2:6d Min%3:6d Max%4:6d',
  	[act, Heap.Overhead, last, min, max]));

end;


procedure TSimIDE.menHelpClick(Sender: TObject);
begin
	Application.HelpJump ('');	
end;

procedure TSimIDE.menHelpHelpClick(Sender: TObject);
begin
	Application.HelpJump ('');
end;

end.
