unit Funcs;

interface

function Empty (const s : string) : boolean;
{berprft ob ein String leer (nur blanks) ist}

function Replicate (s : String; count : integer) : string;
{liefert String der Lnge len gefllt mit c}

function Space (len : integer) : string;
{liefert leeren String der Lnge len}

function Pad (const s : string; len : integer) : string;
{fgt hinten Leerzeichen an / schneidet String ab}

function LPad (const s : string; len : integer) : string;
{fgt vorne Leerzeichen an / schneidet String ab}

function StrTran (s: string; const sFind, sRepl: string): string;
{ersetzt alle sFind durch sRepl }


implementation


function Empty (const s : string) : boolean;
var
	i, len : integer;
begin
	len := length (s);
	Result := false;
	for i := 1 to len do
		if s[i] <> ' ' then exit;
	Result := true;
end;


function Replicate (s : String; count : integer) : string;
var
	i : Integer;
begin
	Result := '';
  for i := 1 to count do
  	Result := Result + s;
end;


function Space (len : integer) : string;
begin
	Result := StringOfChar (' ', len)
end;


function Pad (const s : string; len : integer) : string;
var
	alen	: integer;
begin
	alen := length (s);
	if alen > len then
		Result := Copy (s, 1, len)
	else if alen < len then
		Result := Concat (s, Space (len - alen))
  else
  	Result := s;
end;

function LPad (const s : string; len : integer) : string;
var
	alen	: integer;
begin
	alen := length (s);
	if alen > len then
		Result := Copy (s, alen - len + 1, len)
	else if alen < len then
		Result := Concat (Space (len - alen), s)
  else
  	Result := s;
end;


function StrTran (s: string; const sFind, sRepl: string): string;
var
	p 			: integer;
	findlen, nLen : integer;
	done 		: boolean;
begin
	Result := '';
  nLen := length (s);
	findlen := length (sFind);
  done := (nLen = 0) or (findlen = 0);

	while not done do begin
		p := pos (sFind, s);
		if p > 0 then begin
			Result := Result + Copy (s, 1, p - 1) + sRepl;
      s := Copy (s, p + findlen, nLen);
		end
    else begin
			done := true;
		end
	end;

	Result := Result + s;
end;


end.
