unit SimDlg;

{
	Beispiel fr die Verwendung von Dialogelementen mit SimCoP
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SimExpr, SimCoP, StdCtrls, SimConst, Printers;

type

	TSimLabel		= class (TLabel)
  end;

	TSimButton 	= class (TButton)
  protected
  	FOnClick	: String;
  published
  	property 	__OnClick 	: String
    	read    FOnClick
      write		FOnClick;
  end;

	TSimCheckBox 	= class (TCheckBox)
  protected
  	FOnClick	: String;
  published
  	property 	__OnClick 	: String
    	read    FOnClick
      write		FOnClick;
  end;

  TSimEdit    = class (TEdit)
  protected
  	FOnChange	: String;
  published
  	property	SelStart;
  	property	SelLength;

  	property	__OnChange	: String
    	read		FOnChange
      write		FOnChange;
  end;

  {
    SimForm dient als Dialogfenster fr SimCoP
  }
  TSimForm = class(TForm)
    procedure FormPaint(Sender: TObject);
  private
    { Private-Deklarationen }
		SimCoP		: TSimCoP;
    FOnPaint	: String;

    { Ereignis-Routinen fr SimCoP - Programm }
    procedure ButtonClick (Sender : TObject);
    procedure EditChange (Sender : TObject);

  public
    { Public-Deklarationen }
    {
    	Fr die Reaktion auf Ereignisse mu dem Form das SimCoP-Objekt bekannt
      sein, daher ein eigener Konstruktor:
    }
    constructor CreateSim (oSimCoP : TSimCoP);

    destructor	Destroy; override;

    {
    	Es wre ohne weiteres mglich, alle Controls ber ihren eigenen
      Konstruktor zu erzeugen, und die Properties dann einzeln zuzuweisen.
      So ist es aber in der Anwendung wesentlich einfacher:
    }
    function 	CreateLabel (nLeft, nTop, nWidth, nHeight : Integer;
    					cCaption : String) : TSimLabel;
    function 	CreateButton (nLeft, nTop, nWidth, nHeight : Integer;
    					cCaption : String) : TSimButton;
    function 	CreateCheckBox (nLeft, nTop, nWidth, nHeight : Integer;
    					cCaption : String) : TSimCheckBox;
    function 	CreateEdit (nLeft, nTop, nWidth, nHeight : Integer) : TSimEdit;

  published
  	{
    	Um zur Laufzeit auf die Properties zugreifen zu knnen, mssen sie
      verffentlicht werden:
    }
  	property  Canvas;
    property 	ModalResult;
    {
    	Leider knnen die Form-Ereignisproperties nicht genauso heien, wie
      im Original, deshalb wird hier ein "__" davorgesetzt, SimCoP erkennt
      solche Properties, und ermglicht den Aufruf ohne "__" aus dem SimCoP
      Programm.
    }
    property  __OnPaint : String
    	read		FOnPaint
      write		FOnPaint;

  end;

var
  SimForm: TSimForm;

{
	der Variablen Printer kann man leider nicht mehr unterjubeln, daher:
}
function PrinterCanvas (p : TPrinter) : TCanvas;

procedure SimRegister (SimCoP : TSimCoP);

procedure ClearCanvas (oCanvas : TCanvas; nColor : Integer);

implementation

const

	{
  	Hier werden die Funktionsverffentlichungen fr SimCoP definiert.
    Man beachte: es mu meist keine Wrapper-Funktion geschrieben werden.
    Wichtig!! Diese Informationen mssen 100% richtig eingegeben werden,
    sonst gibt es Schutzverletzungen und eigenartige Laufzeitfehler!
  }

	SimFuncDef : array [1 .. 26] of TFuncDef = (

  { ************ TSimForm ************* }
  	(Name : 'Create';                     				// Name fr SimCoP, mu nicht mit Originalnamen bereinstimmen
        ClassID			: TSimForm;										// Klassentyp, nil bei function und procedure
    		Address 		: @TSimForm.CreateSim;				// Adresse der Funktion
        CallType		: ctDefault or ctConstructor;	// Art des Aufrufes
        ResultType 	: varObject;									// Rckgabewert
							        { Liste der Parametertypen (maximal 16) }
        Parameters 	: (varObject, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Destroy';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.Destroy;
        CallType		: ctDefault or ctDestructor;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'ShowModal';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.ShowModal;
        CallType		: ctDefault;
        ResultType 	: varInteger;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Show';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.Show;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Close';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.Close;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Invalidate';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.Invalidate;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'SetBounds';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.SetBounds;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger,
        							 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

    (Name : 'CreateLabel';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.CreateLabel;
        CallType		: ctDefault;
        ResultType 	: varObject;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger,
        							 varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

    (Name : 'CreateButton';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.CreateButton;
        CallType		: ctDefault;
        ResultType 	: varObject;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger,
        							 varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

    (Name : 'CreateCheckBox';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.CreateCheckBox;
        CallType		: ctDefault;
        ResultType 	: varObject;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger,
        							 varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

    (Name : 'CreateEdit';
        ClassID			: TSimForm;
    		Address 		: @TSimForm.CreateEdit;
        CallType		: ctDefault;
        ResultType 	: varObject;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger,
        							 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

    { ********* TCanvas ************ }

  	(Name : 'FloodFill';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.FloodFill;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'TextOut';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.TextOut;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varInteger, varInteger, varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'TextWidth';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.TextWidth;
        CallType		: ctDefault;
        ResultType 	: varInteger;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'TextHeight';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.TextHeight;
        CallType		: ctDefault;
        ResultType 	: varInteger;
        Parameters 	: (varString, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Ellipse';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.Ellipse;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Rectangle';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.Rectangle;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'RoundRect';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.RoundRect;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varInteger, varInteger, varInteger, varInteger, varInteger, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'MoveTo';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.MoveTo;
        CallType		: ctDefault;
        ResultType 	: varString;
        Parameters 	: (varInteger, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'LineTo';
        ClassID			: TCanvas;
    		Address 		: @TCanvas.LineTo;
        CallType		: ctDefault;
        ResultType 	: varString;
        Parameters 	: (varInteger, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

    { ********* TPrinter ************ }

  	(Name : 'BeginDoc';
        ClassID			: TPrinter;
    		Address 		: @TPrinter.BeginDoc;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'EndDoc';
        ClassID			: TPrinter;
    		Address 		: @TPrinter.EndDoc;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'Abort';
        ClassID			: TPrinter;
    		Address 		: @TPrinter.Abort;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'NewPage';
        ClassID			: TPrinter;
    		Address 		: @TPrinter.NewPage;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'PrinterCanvas';
        ClassID			: nil;
    		Address 		: @PrinterCanvas;
        CallType		: ctDefault;
        ResultType 	: varObject;
        Parameters 	: (varObject, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)),

  	(Name : 'ClearCanvas';
        ClassID			: nil;
    		Address 		: @ClearCanvas;
        CallType		: ctDefault;
        ResultType 	: varEmpty;
        Parameters 	: (varObject, varInteger, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0))

  );

{$R *.DFM}

{
	Die Prozedur SimRegister wird bentigt, um die ntigen Informationen
  fr SimCoP bekannt zu machen.
}

procedure SimRegister (SimCoP : TSimCoP);
begin
	// Funktionen definieren:
	SimCoP.AddFuncList (SimFuncDef);
  // Variable vorbelegen (Klassentypen):
	SimCop.SetVar ('TForm', SimClass (TSimForm));
 	SimCop.SetVar ('TCanvas', SimClass (TCanvas));
  { Printer - Objekt }
  SimCoP.SetVar	('Printer', SimObject (Printer));
  // und die mr* -Konstanten, damit wir die Zahlen nicht auswendig knnen
  // mssen
 	SimCop.SetVar ('mrOK', mrOK);
 	SimCop.SetVar ('mrCancel', mrCancel);
 	SimCop.SetVar ('mrAbort', mrAbort);
 	SimCop.SetVar ('mrRetry', mrRetry);
 	SimCop.SetVar ('mrIgnore', mrIgnore);
 	SimCop.SetVar ('mrYes', mrYes);
 	SimCop.SetVar ('mrNo', mrNo);
 	SimCop.SetVar ('mrAll', mrAll);
  SimCop.SetVar ('fsSurface', fsSurface);
  SimCop.SetVar ('fsBorder', fsBorder);
  SimCop.SetVar ('clAqua', clAqua);
  SimCop.SetVar ('clBlack', clBlack);
  SimCop.SetVar ('clBlue', clBlue);
  SimCop.SetVar ('clDkGray', clDkGray);
  SimCop.SetVar ('clFuchsia', clFuchsia);
  SimCop.SetVar ('clGray', clGray);
  SimCop.SetVar ('clGreen', clGreen);
  SimCop.SetVar ('clLime', clLime);
  SimCop.SetVar ('clLtGray', clLtGray);
  SimCop.SetVar ('clMaroon', clMaroon);
  SimCop.SetVar ('clNavy', clNavy);
  SimCop.SetVar ('clOlive', clOlive);
  SimCop.SetVar ('clPurple', clPurple);
  SimCop.SetVar ('clRed', clRed);
  SimCop.SetVar ('clSilver', clSilver);
  SimCop.SetVar ('clTeal', clTeal);
  SimCop.SetVar ('clWhite', clWhite);
  SimCop.SetVar ('clYellow', clYellow);
end;

procedure ClearCanvas (oCanvas : TCanvas; nColor : Integer);
var
	svColor : TColor;
  svStyle : TBrushStyle;
  rect		: TRect;
begin
	rect.Left 	:= 0;
  rect.Top		:= 0;
  rect.Right 	:= $7FFF;
  rect.Bottom := $7FFF;
	with oCanvas.Brush do begin
  	svColor := Color;
    svStyle := Style;
    Style := bsSolid;
    Color := nColor;
    oCanvas.FillRect (rect);
  	Color := svColor;
    Style := svStyle;
  end;
end;

function PrinterCanvas (p : TPrinter) : TCanvas;
begin
	Result := p.Canvas
end;


constructor TSimForm.CreateSim (oSimCoP : TSimCoP);
begin
	{ Erzeugen des Forms. Aufrufende SimCoP Objekt merken.
  	Im SimCoP Programm mu:
    	TForm.Create (Self)
    aufgerufen werden. }
	inherited Create (Application);
  SimCoP := oSimCoP;
  SimCoP.Register (Self);
end;


destructor TSimForm.Destroy;
begin
	SimCoP.Unregister (Self);
  inherited Destroy;
end;


function 	TSimForm.CreateLabel (nLeft, nTop, nWidth, nHeight : Integer;
    					cCaption : String) : TSimLabel;
begin
	{ Damit all diese Zeilen nicht in SimCoP geschrieben werden mssen: }
	Result := TSimLabel.Create (self);
	with Result do begin
  	Parent	:= self;
  	Left 		:= nLeft;
    Top			:= nTop;
    Width		:= nWidth;
    Height	:= nHeight;
    Caption := cCaption;
    Visible := True;
  end;
end;


function 	TSimForm.CreateButton (nLeft, nTop, nWidth, nHeight : Integer;
	 			  cCaption : String) : TSimButton;
begin
	Result := TSimButton.Create (self);
	with Result do begin
  	Parent	:= self;
  	Left 		:= nLeft;
    Top			:= nTop;
    Width		:= nWidth;
    Height	:= nHeight;
    Caption	:= cCaption;
    Visible := True;
    TButton (Result).OnClick := ButtonClick;
  end;
end;


function 	TSimForm.CreateCheckBox (nLeft, nTop, nWidth, nHeight : Integer;
	 			  cCaption : String) : TSimCheckBox;
begin
	Result := TSimCheckBox.Create (self);
	with Result do begin
  	Parent	:= self;
  	Left 		:= nLeft;
    Top			:= nTop;
    Width		:= nWidth;
    Height	:= nHeight;
    Caption	:= cCaption;
    Visible := True;
    TCheckBox (Result).OnClick := ButtonClick;
  end;
end;


function 	TSimForm.CreateEdit (nLeft, nTop, nWidth, nHeight : Integer) : TSimEdit;
begin
	Result := TSimEdit.Create (self);
	with Result do begin
  	Parent	:= self;
  	Left 		:= nLeft;
    Top			:= nTop;
    Width		:= nWidth;
    Height	:= nHeight;
    Visible := True;
    TEdit (Result).OnChange := EditChange;
  end;
end;


{
	Die Ereignisbehandlungsroutinen mssen nach SimCoP umgeleitet werden
}
procedure TSimForm.ButtonClick (Sender : TObject);
begin
	if Sender is TSimButton then begin
  	with Sender as TSimButton do
    	if FOnClick <> '' then SimCoP.CallBack (FOnClick, [SimObject (Sender)])
  end else if Sender is TSimCheckBox then begin
  	with Sender as TSimCheckBox do
    	if FOnClick <> '' then SimCoP.CallBack (FOnClick, [SimObject (Sender)])
  end;
end;


procedure TSimForm.EditChange (Sender : TObject);
begin
	if Sender is TSimEdit then
  	with Sender as TSimEdit do
    	if FOnChange <> '' then SimCoP.CallBack (FOnChange, [SimObject (Sender)]);
end;


procedure TSimForm.FormPaint(Sender: TObject);
begin
	if FOnPaint <> '' then SimCoP.CallBack (FOnPaint, [SimObject (Sender)])
end;

end.
