//***************************************************************************
// 2D_OBJS.H 					    Copyright 1996 by MUTTLEY
// Header file for manipulating 2D wireframe graphics  
//***************************************************************************

#define WIN_XMIN	      5		// Top edge of clipping window
#define WIN_XMAX	    315		// Bottom edge of clipping window
#define WIN_YMIN	      5		// Left edge of clipping window
#define WIN_YMAX	    235		// Right edge of clipping window	

#define PAGE_0		      0		// Offset of page 0 (Size = 640 x 240)
#define PAGE_1		 0x9600		// Offset of page 1 
#define PAGE_2		 0xe100		// Offset of page 2 

#define SPEED		0.04		// Used in thrust calculations
#define FRICTION	0.995		// Used to slow objects down

#define PLAYERTYPE	     0		// Used to indicate the type of
#define ENEMYTYPE	     1		// object so that can we do different
#define FRAGTYPE	     2          // things with them within the same	
#define ROCKTYPE	     3		// routines	

#define LARGE		     2		// Size of object so that we can
#define MEDIUM		     1          // tell how to explode it	
#define SMALL		     0			

#define ACTIVE		     2		// Status of objects so that we can
#define DYING		     1		// decide how to draw them
#define INACTIVE	     0		

#define	MAXBULLETS   	    50		// Max number of bullets
#define MAXTHRUST  	    50		// Max number of thrust particles
#define MAXENEMIES 	    50
#define MAXFRAGS	    50

//---------------------------------------------------------------------------

struct PointType {			// Single local point of a shape
	int x, y;
};

struct VertexType {
	int lx, ly;			// Local co-ords of vertex
	int rx, ry;			// Rotated local co-ords of vertex
	int sx, sy;			// Screen co-ords of vertex 
	int ox, oy;			// Previous screen co-ords of vertex
};

struct ObjectType {
	int Type;			// Type of object eg Fragment, Enemy
	int Scale;			// Size of object , LARGE or SMALL
	int Color;			// Color of the object
	int NumVerts;			// Number of vertices object has
	int Track_Index;		// Position within wave pattern array
	float x, y;			// x,y position of centre of object
	float vx, vy;			// Velocity of object
	float ax, ay;			// Acceleration of object
	int mx, my;			// Maximum speed of object
	int Angle;			// Current angle of object +ive x = 0
	int Rotate;			// Amount to rotate object by
	int State;			// Alive, dying, or dead
	VertexType *VertPtr;		// Pointer to array of vertices
};

struct ParticleType {
	int Color;			// Color of the particle
	float x, y;			// x,y position of the particle
	float ox, oy;			// Old x,y position of the particle
	float vx, vy;			// Velocity of the particle
	int Coll_Check;			// Used in collision checking
	int State;			// Active or inactive
};

struct ObjectListType {
	ObjectType *ObjPtr;		// Array of pointers to objects
};

//--- DEFINED EXTERNALS -----------------------------------------------------

// Set up page array to hold offsets of each page in display memory
static unsigned int PageOffsets[3] = {PAGE_0, PAGE_1, PAGE_2};

// These arrays will hold the Sin and Cos look-up tables
extern float Sin_Look[361];
extern float Cos_Look[361];

// These definitions hold the co-ords of different attack waves
extern PointType Wave_3Leaf[401];			

extern void Explode_Object(ObjectType *Object);
extern void Spawn_Object(ObjectType *Object);


//---------------------------------------------------------------------------

void Thrust_Object(ObjectType *Object);
void Trans_Object(ObjectType *ObjToMove);

void Draw_Object(ObjectType *ObjToDraw, int PageNum);
void Erase_Object(ObjectType *ObjToDraw, int PageNum);

static int Encode_Point(int x, int y);
void Clip_Line(int x1, int y1, int x2, int y2, int Color, int PageNum);

void Check_Object(ObjectType *Object1, ObjectType *Object2);

void Fire_Thrust(ObjectType *Object, ParticleType *Thrust);

void Trans_Particle(ParticleType *Part);
void Draw_Particle(ParticleType *Part, int PageNum);
void Erase_Particle(ParticleType *Part, int PageNum);

void Fire_Bullet(ObjectType *Object, ParticleType *Bullet);	
void Check_Bullet(ParticleType *Bullet, ObjectType *Object);
