//***************************************************************************
// KEYS.CPP					    Copyright 1996 by MUTTLEY
// Routines to install and remove new keyboard ISR
//***************************************************************************

#include <dos.h>
#include <bios.h>
#include <conio.h>
#include "keys.h"

char ScanChar;
int ScanCode;

//---------------------------------------------------------------------------
#pragma off (check_stack)
void _interrupt _far NewKeyISR()
{
  _enable();				// Re-enable interrupts
  ScanChar=inp(KEY_BUFFER);		// Get the key that was pressed
  ScanCode=(int)ScanChar;		// Convert it to a scan code
  ScanChar=inp(KEY_CONTROL);		// Set Control reg to reflect key was read
  ScanChar |= 0x82;			// Set proper bits to reset keyboard flip flop
  outp(KEY_CONTROL, ScanChar);		// Send new data back to Control reg
  outp(KEY_CONTROL, ScanChar & 0x7f);   // Complete the reset
  outp(INT_CONTROL, 0x20);		// Tell PIC to re-enable interrupts
  
 if(ScanCode > 128) 			// If code was a BREAK code...
    KeyBuffer[ScanCode-128]=0;		// flag relevant array element 
 else 					// else was a MAKE code so...
    KeyBuffer[ScanCode]=1;		// flag relevant array element 
}
#pragma on (check_stack)


//---------------------------------------------------------------------------
void InitNewKeyISR()
{
 OldKeyISR = _dos_getvect(KEYBOARD_INT);	// Save address of old key ISR
 _dos_setvect(KEYBOARD_INT, NewKeyISR);		// Set up new keyboard ISR
 for (int i=0; i<256; i++) {			// Clear keyboard buffer
     KeyBuffer[i] = 0;
 }
}


//---------------------------------------------------------------------------
void RestoreOldKeyISR()
{
 _dos_setvect(KEYBOARD_INT, OldKeyISR);		// Restore the old key ISR
}
