/* Death Trap - created by Dhonn Lushine */
/* 640 rooms */

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <stdlib.h>

#include "cpp\include\graphics.h"
#include "cpp\include\sound.h"

#define  getmemxy(buf,x,y)              (*(buf+(y<<8)+(y<<6)+x))
#define  putmemxy(buf,x,y,c)            (*(buf+(y<<8)+(y<<6)+x)=c)

/* Global buffers */
char far *mapbuffer;            /* holds 512-10x10 tiles */
char far *spritebuffer;         /* holds 512-10x10 tiles */


/* protos */
void box(int x,int y,char c);
void LoadSprite(char far *screen,int xbuf,int ybuf,int x,int y);
void display_map(int x,int y);
void display_map_secret(int x,int y);
void display_sprite_secret(void);
void load_file(char *file,char far *source);
void buffer_setup(void);
void buffer_desetup(void);
void show_buffer(char far* source);


/* The main program */
void main()
{
        int a,x=0,y=0;
	unsigned d;
	char done=0;
        srand((unsigned)time(NULL));
	
        buffer_setup();

	for(d=0;d<32000;d++)
	{
		putmemxy(double_buffer,(rand()%320),(rand()%200),215);
		putmemxy(double_buffer,(rand()%320),(rand()%200),112);
	}

        while(!done){
                /* ClearScreen_DB(0); */

		if(x>310) x=310;
		if(y>190) y=190;
		if(x<0) x=0;
		if(y<0) y=0;

        	display_map(x,y);
                /* printf("%i %i\r",x,y); */

		if(kbhit())
		{        
			switch(getch())
			{
				case 0x50: y++;	break;
				case 0x48: y--; break;
				case 0x4b: x--; break;
				case 0x4d: x++; break;
				case 'm':display_map_secret(x,y); break;
				case 0x1b: done=1;break;
				case 's':display_sprite_secret();break;
  	        	}
		}
	}
        
        

        buffer_desetup();
}



void box(int x,int y,char c)           /* Draw a box */
{
        int h,w;
        x*=10;
        y*=10;

        for(h=y;h<(y+10);h++)
        for(w=x;w<(x+10);w++)
                putmemxy(double_buffer,w,h,c);
}

        
/* Each tile will be 10x10 pixels big */
void LoadSprite(char far *screen,int xbuf,int ybuf,int x,int y)
{
        int h,h2,w,w2,c,i=x*10;        

        xbuf*=10;
        ybuf*=10;
        xbuf+=10;
        ybuf+=10;       
	y*=10;


        for(h=ybuf-10;h<ybuf;h++,y++)
        for(w=xbuf-10,x=i;w<xbuf;w++,x++)
        {
                c=getmemxy(spritebuffer,w,h);
                if(c)   putmemxy(screen,x,y,c);

        }			
}	



/* The map segment will be 10x10 tiles */
/* Display a segment of the map to full screen */
void display_map(int x,int y)
{
        int a,b,xtile=10,ytile=5,i=xtile,j;

        /*
	y*=10;
	x*=10;
	*/

        x+=10;
        y+=10;
       

        for(b=y-10;b<y;b++,ytile++)   /* Calculate position on buffer */
        for(a=x-10,xtile=i;a<x;a++,xtile++)   /* 32 tiles by 20 tiles */
        {
                switch(getmemxy(mapbuffer,a,b))
                {                      

                        case 'a': /* dirt1 */
                                  LoadSprite(double_buffer  ,0,0,xtile,ytile);
                                  break;

                        case 'b': /* dirt2 */
                                  LoadSprite(double_buffer  ,1,0,xtile,ytile);
                                  break;

                                  /* weeds1 */
                        case 'c': LoadSprite(double_buffer  ,2,0,xtile,ytile);
                                  break;

                                  /* weeds2 */
                        case 'd':
                                  LoadSprite(double_buffer  ,3,0,xtile,ytile);
                                  break;
			
			case 'e': /* trees1 */
                                  LoadSprite(double_buffer  ,4,0,xtile,ytile);
                                  break;

                        case 'f': /* trees2 */
                                  LoadSprite(double_buffer  ,5,0,xtile,ytile);
                                  break;

                                  /* rock1 */
                        case 'g': LoadSprite(double_buffer  ,6,0,xtile,ytile);
                                  break;

                                  /* rock2 */
                        case 'h': LoadSprite(double_buffer  ,7,0,xtile,ytile);
                                  break;
			
			case 'i': /* hole1 */
                                  LoadSprite(double_buffer  ,8,0,xtile,ytile);
                                  break;

                        case 'j': /* hole2 */
                                  LoadSprite(double_buffer  ,9,0,xtile,ytile);
                                  break;

			          /* dirt1 */
                        case 'k': LoadSprite(double_buffer  ,10,0,xtile,ytile);
                                  break;

                                  /* dirt2 */
                        case 'l': LoadSprite(double_buffer  ,11,0,xtile,ytile);
                                  break;
			
                        case 'm': /* fence1 */
                                  LoadSprite(double_buffer  ,12,0,xtile,ytile);
                                  break;

                        case 'n': /* fence2 */
                                  LoadSprite(double_buffer  ,13,0,xtile,ytile);
                                  break;
			
                        case 'o': /* water1 */
                                  LoadSprite(double_buffer  ,14,0,xtile,ytile);
				  break;
		
                        case 'p': /* water2 */
                                  LoadSprite(double_buffer  ,15,0,xtile,ytile);
				  break; 
			
                        case 'q': /* water3 */
                                  LoadSprite(double_buffer  ,16,0,xtile,ytile);
				  break;
		
                        case 'r': /* water4 */
                                  LoadSprite(double_buffer  ,17,0,xtile,ytile);
				  break; 
			
                        case 's': /* water5 */
                                  LoadSprite(double_buffer  ,18,0,xtile,ytile);
				  break;
		
                        case 't': /* plain water */
                                  LoadSprite(double_buffer  ,19,0,xtile,ytile);
				  break; 

                        case 'u': /* brick1 */
                                  LoadSprite(double_buffer  ,20,0,xtile,ytile);
				  break;
		
                        case 'v': /* brick2 */
                                  LoadSprite(double_buffer  ,21,0,xtile,ytile);
				  break; 

                        case 'w': /* brick fence1 */
                                  LoadSprite(double_buffer  ,22,0,xtile,ytile);
				  break;
		
                        case 'x': /* brick fence2 */
                                  LoadSprite(double_buffer  ,23,0,xtile,ytile);
				  break; 

                        case 'y': /* brick fence3 */
                                  LoadSprite(double_buffer  ,24,0,xtile,ytile);
				  break;

                        case 'z': /* brick fence4 */
                                  LoadSprite(double_buffer  ,25,0,xtile,ytile);
				  break;

                        
			default:  box(xtile,ytile,ytile+a);

                        /* Add more later */        
                 }
        }
                 /* VertRetrace(); */
                 /* BlitPage(); */
                 show_buffer(double_buffer);
}


/* Secret map view mode - ( shift - ) */
void display_map_secret(int x,int y)
{
        int xmap,ymap,h,w;
	
	x/=10;
	y/=10;

        VertRetrace();
        ClearScreen(0);                 /* Clear screen only (!db) */

        for(ymap=0;ymap<200;ymap+=10)   /* Display vert and horz lines */
                Line_H(0,319,ymap,2);
        for(xmap=0;xmap<320;xmap+=10) 
                Line_V(0,199,xmap,2);

        x*=10;
        y*=10;

        for(h=y+1;h<(y+10);h++)
        for(w=x+1;w<(x+10);w++)
                putmemxy(video_buffer,w,h,1);

        getch();

        VertRetrace();
        BlitPage();                     /* Display old frame */
}


/* display secret sprites page ( shift + )*/
void display_sprite_secret(void)
{
        VertRetrace();
        _fmemcpy(video_buffer,spritebuffer,64000);
        getch();
        VertRetrace();
        BlitPage();
}

/* Load files to buffers */
void load_file(char *file,char far *source)
{
        FILE *fp;
        int c;
        if((fp=fopen(file,"rb"))==NULL)
        {
                buffer_desetup();
                printf("Cannot open file");
                exit(1);
        }


        while(!feof(fp))
        {
                *(source++)=fgetc(fp);
        }
        fclose(fp);
}
        


/* Buffer setup */
void buffer_setup(void)                     /* Allocate 64k of memory */                
{
        double_buffer=  farmalloc(64000);
        if(double_buffer==NULL)
        {
                printf("Memory error #1");
                exit(1);
        }
        mapbuffer=      farmalloc(64000);
        if(mapbuffer==NULL)
        {
                printf("Memory error #2");
                farfree(double_buffer);
                exit(1);
        }
        spritebuffer=   farmalloc(64000);
        if(spritebuffer==NULL)
        {
                printf("Memory error #3");
                farfree(double_buffer);
                farfree(mapbuffer);
                exit(1);
        }
	_fmemset(mapbuffer,0,64000);
        _fmemset(spritebuffer,0,64000);
	_fmemset(double_buffer,0,64000);
	load_file("Death1.raw",mapbuffer);	/* Map */
	load_file("Death2.raw",spritebuffer);	/* sprites */
        asm mov ax,13h
        asm int 10h
}

/* Buffer desetup*/
void buffer_desetup(void)
{
        farfree(double_buffer);
        farfree(mapbuffer);
        farfree(spritebuffer);
        asm mov ax,3h
        asm int 10h
}

/* show buffer */
void show_buffer(char far* source)
{
        asm
        {
        push    ds
        mov     cx,32000
        les     di,video_buffer
        lds     si,source
        cld
        rep     movsw
        pop     ds
        }
}

