/*
GAME PROGRAMMING TUTORIAL
Copyright (C) 1996 Emmanuel Lagare

PIXEL PLOTTING WITH NEARPTR.H

Thanks to Brennan Underwood (brennan@rt66.com) for helping me with this.

Using far pointers are fine however using near pointers are faster. On the
down side however, memory protection is turned off. This is actually no big
deal if you're used to it.

Using near pointers is a lot more similar to real mode programming, you
set up a pointer to the video buffer as a char pointer. However, you must
add to it the conventional memory base used by DJGPP at run time. This value
is stored in the variable __djgpp_conventional_base.

Below is a sample code to demonstrate pixel plotting in Mode 13h
using DJGPP's near pointers.
*/

#include <sys/nearptr.h>
#include <go32.h> /* for _dos_ds */
#include <dos.h>

#define GRAPHICS        0x013
#define TEXT            0x03

char *video_buffer = (char *)0xa0000;

void set_video_mode(int mode)
{
        union REGS regs;

        regs.x.ax = mode;
        int86(0x10, &regs, &regs);
}

void put_pixel(short int x, short int y, char color)
{
        video_buffer[(y << 8) + (y << 6) + x] = color;
}

void main(void)
{
        unsigned count;

        /* disable all memory protection */
        __djgpp_nearptr_enable();
        video_buffer += __djgpp_conventional_base;

        /* go to graphics mode */
        set_video_mode(GRAPHICS);

        /* fill up the screen with random pixels */
        for(count = 0; count < 32000; count++) {
                put_pixel(rand() % 320, rand() % 200, rand() % 256);
        }

        /* go back to text mode */
        set_video_mode(TEXT);

        /* reenable memory protection */
        __djgpp_nearptr_disable();
}
