/*
GAME PROGRAMMING TUTORIAL
Copyright (C) 1996 Emmanuel Lagare

DISPLAYING TEXT

This is based on the code in the book "Tricks of the Game Programming Gurus
by Andre LaMothe.

Okay, now you can display some fancy graphics but no text. Sure you can
design you own character set (you can even vary the font face) and blt them
to the screen. But that would take some time to do. What we need is a quick
and dirty way to display text.

As it turns out, there is already a whole bitmapped character set ready for
our use. Where? You're looking at it (assuming you're using your favorite
DOS text editor). Where do you think is the characters you're looking at
coming from? Why in the ROM of course. You don't see DOS load character sets
from disk much, do you? This set starts at 0xf000:0xfa6e. That's a segment
offset address so to use that in DJGPP we apply the same conversion we did
with the video buffer (a000:0000 becomes __djgpp_conventional_base + 0xa0000)
giving us the value __djgpp_conventional_base + 0xffa6e for the set's
address.

Each character is defined as a bit map of 8x8 bits. That means a character
is defined by 8 bytes with each byte defining a row of the character's
bitmap. The location of this information can be computed by multiplying the
character's ASCII value by 8 and adding the product to the rom character set
address. To display the character, simply get the first byte and scan through
the 8 bits. If a bit is set display a pixel to the corresponding position.
Do this with the second byte, and so on up to the eighth byte. Voila! You've
displayed a character! To display strings, simply go at it a character at a
time.

Pretty simple, huh? Below is the implementation and example.
*/

#include <sys/nearptr.h>
#include <go32.h> /* for _dos_ds */
#include <dos.h>

#define GRAPHICS        0x013
#define TEXT            0x03

#define CHAR_WIDTH  8
#define CHAR_HEIGHT 8

char *video_buffer = (char *)0xa0000;
char *rom_char_set = (char *)0xffa6e;


void set_video_mode(int mode)
{
        union REGS regs;

        regs.x.ax = mode;
        int86(0x10, &regs, &regs);
}

/* new */
void char_blt(int x, int y, int color, unsigned char c)
{
        int offset, x2, y2;
        char *work_char;
	unsigned char bit_mask = 0x80;

        work_char = rom_char_set + c * CHAR_HEIGHT;

        offset = (y << 8) + (y << 6) + x;

        for(y2=0; y2<CHAR_HEIGHT; y2++) {
		bit_mask = 0x80;
                for(x2=0; x2<CHAR_WIDTH; x2++) {
			if((*work_char & bit_mask))
                                video_buffer[offset+x2] = color;
			bit_mask = (bit_mask >> 1);
		}
                offset += 320;
		work_char++;
	}
}

/* new */
void string_blt(int x, int y, int color, char *string)
{
	int index;

	for(index=0; string[index] != 0; index++) {
                char_blt(x+(index<<3),y,color,string[index]);
	}
}

void main(void)
{
        unsigned count;

        /* disable all memory protection */
        __djgpp_nearptr_enable();
        video_buffer += __djgpp_conventional_base;
        rom_char_set += __djgpp_conventional_base;

        /* go to graphics mode */
        set_video_mode(GRAPHICS);

        /* fill up the screen with "JAY" */
        for(count = 0; count < 4000; count++) {
                string_blt(rand() % 296, rand() % 192, rand() % 256, "JAY");        
        }
        
        /* go back to text mode */
        set_video_mode(TEXT);

        /* reenable memory protection */
        __djgpp_nearptr_disable();
}
