/*
GAME PROGRAMMING TUTORIAL
Copyright (C) 1996 Emmanuel Lagare

MODE 13H

First of all, welcome to my game programming tutorial. I hope you learn from
it as I will. We will be using DJGPP for the discussion and the code.
However, the stuff in this tutorial can still, with minor modifications, be
applied using other compilers. We'll begin the tutorial with an introduction
to Mode 13h.

Mode 13h is the techie name for VGA's 320 pixel by 200 pixel with 256 color
mode. It was commonly used because it has the most colors available then and
because it is particularly simple to use (one byte = one pixel, video buffer
is one contiguous block of memory).

Getting to Mode 13h is a simple matter of calling Int 10h with AX=0013h.
To get back to text mode simply call Int 10h again but with AX=0003h.

Below is a sample code to demonstrate setting Mode 13h.
*/

#include <dos.h>

#define GRAPHICS        0x013
#define TEXT            0x03

void set_video_mode(int mode)
{
	union REGS regs;

	regs.x.ax = mode;
	int86(0x10, &regs, &regs);
}

void main(void)
{
	unsigned long count;

	/* go to graphics mode */
	set_video_mode(GRAPHICS);

	delay(1000);

	/* go back to text mode */
	set_video_mode(TEXT);
}