/*
GAME PROGRAMMING TUTORIAL
Copyright (C) 1996 Emmanuel Lagare

GETTING INPUT FROM THE MOUSE

There's really nothing much to say about getting input from the mouse. The
code for getting input is already in the mouse driver and all we need to do
is write the C interface to it.

How? Simply put the function number into AX and do an Int 33h. The most basic
functions are:

Number          Return
0x0             initializes mouse, AX is 0x0 if failed, 0xffff if successful
0x1             none, shows mouse cursor
0x2             none, hides mouse cursor
0x3             BX contains mouse button status, CX and DX contains x and y
		positions (absolute) respectively
0xb             BX contains mouse button status, CX and DX contains x and y
		positions (relative to last reading) respectively

And one more thing, the mouse buttons status is coded as follows:

Bit             Meaning
1               Left button
2               Right button
3               Center button

Below is the code.
*/

#include <dpmi.h>
#include <go32.h>
#include <dos.h>
#include <pc.h>

#define _M_L    0x01    /* mouse left button */
#define _M_R    0x02    /* mouse right button */
#define _M_C    0x04    /* mouse center button */

#define _M_X    0x01  /* mouse, x axis */
#define _M_Y    0x02  /* mouse, y axis */

int mouse_detect(void)
{
	union REGS regs;

	regs.x.ax = 0x0;
	int86(0x33, &regs, &regs);

	return regs.x.ax;
}

void mouse_show(void)
{
	union REGS regs;

	regs.x.ax = 0x01;
	int86(0x33, &regs, &regs);
}

void mouse_hide(void)
{
	union REGS regs;

	regs.x.ax = 0x02;
	int86(0x33, &regs, &regs);
}

unsigned char mouse_button(unsigned char button)
{
	union REGS regs;

	regs.x.ax = 0x3;
	int86(0x33, &regs, &regs);

	return (regs.x.bx & button);
}

void mouse_abs_pos(int *x, int *y)
{
	union REGS regs;

	regs.x.ax = 0x03;
	int86(0x33, &regs, &regs);
	*x = regs.x.cx;
	*y = regs.x.dx;

	return;
}

int mouse_rel_pos(int *x, int *y)
{
	union REGS regs;

	regs.x.ax = 0xb;
	int86(0x33, &regs, &regs);
	*x = regs.x.cx;
	*y = regs.x.dx;

	return (*x|*y);
}

void main(void)
{
	int x = 0, y = 0;
	unsigned char l, c, r;

	l = c = r = 0;
	if (mouse_detect()) {
		printf("Mouse found - press L and R button to quit\n");
		mouse_show();
		do {
			mouse_abs_pos(&x,&y);
			l = mouse_button(_M_L);
			c = mouse_button(_M_C);
			r = mouse_button(_M_R);
			printf("%9d %9d ",x,y);
			if (l) printf("L ");
			else printf("l ");
			if (c) printf("C ");
			else printf("c ");
			if (r) printf("R");
			else printf("r");
			printf("\n");
		} while(!(l&&r));
		mouse_hide();
	} else printf("No mouse found");
}
