/*
GAME PROGRAMMING TUTORIAL
Copyright (C) 1996 Emmanuel Lagare

MUSIC

What is SB_LIB? SB_LIB is the shorthand for the SOUND BLASTER LIBRARY for
DJGPP. It was coded by Joel Hunter (based on the Varmint's Audio Tools code
by Eric Jorgensen).

Music, what do we need them for? Well, though some people say that music
"detracts from the atmosphere" (I myself turn off all the music whenever
I play games), it does sometimes play a vital role in keeping the flow of the
game... well... flowing when used properly. And playing music with SB_LIB
is simply awesome. No, we won't be playing the tin can band sound of MIDIs
(for those of us who don't have wave table synthesis cards anyway). We'll be
using MODs or modules.

So what are MODs? MODs are essentially software based wavetable synthesis. 
Some cards, notably the Sound Blaster AWE32 and the Gravis Ultrasound,
support wave table synthesis on hardware. That is, the digitized instrument
samples are stored in ROM (or even RAM) and processing is done by the card. 
Even MIDI sounds awesome with wave table synthesis cards. MODs, on the other
hand, store the  digitized instrument samples on the file and the the
instrument playing sequence is processed by the CPU. Of course, since this
is just emulation of what should have been a sound card function, it entails
some CPU overhead. But hey, that Pentium seems a bit idle. The overall
result is the same, you hear the real instruments playing. 

The SB_LIB MOD playing routines are pretty simple. We will tackle only the
basic functions in the example. Remember to add sb_lib.a when compiling, i.e.
use "gcc -o music music.c sb_lib.a".

*/
#include "sb_lib.h"

void main(int argc, char *argv[])
{
        sb_mod_file *mod;

        /* setup driver */
        sb_install_driver(11000);

        /* setup mod specified in command line */
        mod=sb_load_mod_file(argv[1]);

        /* play mod */
        sb_mod_play(mod);
        
        /* wait till playing ends */
        while (sb_mod_active);
        
        /* clean up */
        sb_free_mod_file(mod);

        sb_uninstall_driver();
}
