/*
GAME PROGRAMMING TUTORIAL
Copyright (C) 1996 Emmanuel Lagare

SOUND

What is SB_LIB? SB_LIB is the shorthand for the SOUND BLASTER LIBRARY for
DJGPP. It was coded by Joel Hunter (based on the Varmint's Audio Tools code
by Eric Jorgensen).

Sound, what do we need them for? Although music sometimes detracts from the
atmosphere, sound adds to the atmosphere. Even the greatest looking graphics
will fail to immerse the player in the alternate reality game programmers
love so much to create if there is no sound or if sound is improperly used.

SB_LIB can recognize WAV, VOC, and RAW (essentially headerless) sample files. 
It can also play these files back one after the other (queued) or mixed. You
can also define a function which will be called when a sound sample stops
playing.

The SB_LIB sample playing routines are pretty simple. We will tackle only the
basic functions in the example. Remember to add sb_lib.a when compiling, i.e.
use "gcc -o sound sound.c sb_lib.a".
*/
#include "sb_lib.h"

int sb_sample_active = 1;

void callback(void)
{
        sb_sample_active = 0;
}

void main(int argc, char *argv[])
{
        sb_sample *sound;

        /* setup driver: make sure sample is in the specified frequency */
        /* if not, convert the sample using sb_convert_frequency() */
        sb_install_driver(11000);

        /* setup WAV file specified in command line */
        sound=sb_load_sample(argv[1],_SB_WAV);
        sound->callback=callback;
        
        /* play sample: you can also use _sb_queue_sample() */
        sb_mix_sample(sound);
        
        /* wait till playing ends */
        while (sb_sample_active);
        
        /* clean up */
        sb_free_sample(sound);
        sb_uninstall_driver();
}
