/*
GAME PROGRAMMING TUTORIAL
Copyright (C) 1996 Emmanuel Lagare

TRANSPARENT BIT BLTS

If you want your bitmap to contain see-thru areas in them, you need to
do a few more things.

First, you must assign a value to be the transparent color. This value
is usually zero. You will then use this value in the areas where you
want to have holes.

Second, instead of just copying the whole strip, you need to check each
pixel of the strip if it is transparent or not. If it is then don't plot
that pixel, otherwise go on and plot it.

Below is a sample code to transparent bit blitting.
*/

#include <sys/nearptr.h>
#include <go32.h> /* for _dos_ds */
#include <dos.h>

#define GRAPHICS        0x013
#define TEXT            0x03

char *video_buffer = (char *)0xa0000;

void set_video_mode(int mode)
{
	union REGS regs;

	regs.x.ax = mode;
	int86(0x10, &regs, &regs);
}

void transparent_bit_blt(int x, int y, char *buffer)
{
	int xindex, yindex, offset = (y << 8) + (y << 6) + x;
	char width = buffer[0], height = buffer[1];

	buffer += 2; /* skip the first two bytes */
	for (yindex = 0; yindex < height; yindex++) {
	for (xindex = 0; xindex < width; xindex++) {
		if (buffer[xindex]) {
			video_buffer[offset+xindex] = buffer[xindex];
		}
	}
	offset += 320; /* next line of video buffer */
		buffer += width; /* next line of bitmap */
	}
}

char bitmap[102] = {
	10,10,                          /* length and height of block */
	15,15,15,15,15,15,15,15,15,15,  /* strip 1 */
	15,00,00,00,00,00,00,00,00,15,
	15,00,00,00,00,00,00,00,00,15,
	15,00,00,00,00,00,00,00,00,15,
	15,00,00,00,00,00,00,00,00,15,
	15,00,00,00,00,00,00,00,00,15,
	15,00,00,00,00,00,00,00,00,15,
	15,00,00,00,00,00,00,00,00,15,
	15,00,00,00,00,00,00,00,00,15,
	15,15,15,15,15,15,15,15,15,15   /* strip 10 */
};

void main(void)
{
	unsigned count;

	/* disable all memory protection */
	__djgpp_nearptr_enable();
    video_buffer += __djgpp_conventional_base;

	/* go to graphics mode */
	set_video_mode(GRAPHICS);

	/* fill up the screen with our bitmap */
	for(count = 0; count < 32000; count++) {
		transparent_bit_blt(rand() % 310, rand() % 190, bitmap);
	}

	/* go back to text mode */
	set_video_mode(TEXT);

	/* reenable memory protection */
	__djgpp_nearptr_disable();
}