/*
 * rnd.c
 */


#include <stdio.h>
#include "rnd.h"

static rnd_t  *c_state = NULL;
static uint   *c_s, *c_d;


uint  rnd(void)  {
	uint  result;

	result = *c_d = (*c_s + *c_d);
	if (++c_d == c_state->data + RND_DATASIZE)
		c_d = c_state->data;
	if (++c_s == c_state->data + RND_DATASIZE)
		c_s = c_state->data;
	return((result >> 1) & 0x7fff);
}


void  rnd_init(rnd_t *state, int seed)  {
	uint  i;

	state->indent = 0;
	for (i = 0;  i < RND_DATASIZE;  ++i)  {
		state->data[i] = seed;
		seed = seed * 11 + 3;
	}
}


void  rnd_use(rnd_t *state)  {
	if (c_state != NULL)
		c_state->indent = c_s - c_state->data;
	c_state = state;
	if (state != NULL)  {
		c_s = state->data + state->indent;
		c_d = c_s + RND_INDENT;
		if (c_d >= c_state->data + RND_DATASIZE)
			c_d -= RND_DATASIZE;
	}
}

