/*

NanoTech - a 3d game engine
Copyright (C) 1996  Sean Lane Fuller

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Sean Lane Fuller
124 Autumn Lane
Tullahoma, TN 37388
615-393-4550
email: fuller@edge.net

*/

typedef float fixed;
extern char area_type;
typedef unsigned char angle;
float get_obj_radius(int i);
float get_obj_midy(int i);
unsigned char get_obj_type(int i);
int get_obj_id(int i);
void init_3d();
void term_3d();
struct obj_struct *add_obj(int id, unsigned char type);
int del_obj(int id);
int upd_obj(int id, angle yaw, angle pitch, angle roll,
      fixed tx, fixed ty, fixed tz);
int time_slice();
int mark_obj(int id);
int unmark_obj(int id);
int locate_obj(int x, int y);
int is_obj_marked(int id);
int rotate_obj(int id, int dyaw, int dpitch, int droll);
int translate_obj(int id, fixed dx, fixed dy, fixed dz);
int scale_obj(int id, fixed dx, fixed dy, fixed dz);
void  make_scene();
void  draw_scene();
void  pyramid(fixed P[][5], int c);
void  cube(fixed P[][5], int c);
void  wall(fixed P[][5], int c);
void  tran3(fixed tx, fixed ty, fixed tz, fixed A[][5]);
void  scale3(fixed sx, fixed sy, fixed sz, fixed A[][5]);
void  rot3(int m, fixed theta, fixed A[][5]);
void  mult3(fixed A[][5], fixed B[][5], fixed C[][5]);
void  scale3(fixed sx, fixed sy, fixed sz, fixed A[][5]);
void clear_scene();
void  clipscene();
int save_area_by_name(char *filename);
int save_area(int l);
//int load_area(char *filename);
int load_area(int l);
struct vector3 { fixed x, y, z; };
#define maxv 3000
#define maxf 1600
#define maxlist 4000
#define max(a, b) ((a) > (b) ? (a) : (b))
#define min(a, b) ((a) < (b) ? (a) : (b))
#define horiz 256
#define vert 125
#define maxpoly 20
extern fixed epsilon;
extern int firstfree, nov, ntv, nof, ntf; /* counts */
extern struct vector3 act[maxv], obs[maxv], setup[maxv]; /* actual, observed, setup */
extern struct vector3 pro[maxv];
extern int facfront[maxf], size[maxf];
extern int colour[maxf];
extern int nfac[maxf];
extern int faclist[maxlist];
extern struct vector3 direct, eye, zero;
extern fixed Q[5][5];
extern fixed ppd;

extern fixed mx, my, mz;
extern fixed yaw, pitch, roll;
extern fixed sin_yaw, cos_yaw, sin_pitch, cos_pitch, sin_roll, cos_roll;

extern char wire_frame;
extern int num_objs;
extern int collision_detection;
int collision(fixed x, fixed y, fixed z, fixed delta, int id);

#define ON 1
#define OFF 0
#define MAXVAR 3
struct obj_struct
{
   int id;
   unsigned char type;
   unsigned char clipped;
   unsigned char off;
   long state;
   int var[MAXVAR];
   int first_fac;
   int nof;
   int first_vert;
   int nov;
   int first_list;
   int nol;
   angle yaw;
   angle roll;
   angle pitch;
   fixed x, y, z;
   struct vector3 *act;
   unsigned char marked;
   fixed radius;
   fixed midx, midy, midz;  // transformed centroid
   fixed obsx, obsy, obsz;  // observed position of centroid
   fixed actx, acty, actz;  // untransformed centroid
};
extern struct obj_struct **obj;
struct obj_struct *find_obj(int i);
extern float psin[256];
extern float pcos[256];
