/*

NanoTech - a 3d game engine
Copyright (C) 1996  Sean Lane Fuller

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Sean Lane Fuller
124 Autumn Lane
Tullahoma, TN 37388
615-393-4550
email: fuller@edge.net

*/


#include <stdio.h>
#include <stdlib.h>

/* this program will create a 3d checkerboard pattern */

#define W 290
#define N 3
#define D 290
#define M 1000
int px[M], pz[M];
int n = 0;
int s[M][4];
int f = 0;

int add_pt(int x, int z)
{
   int i;
   for (i=0; i<n; i++)
   {
      if (x == px[i] && z == pz[i]) return i;
   }
   px[n] = x; pz[n] = z;
   n++;
   return n - 1;
}

int add_square4(int a, int b, int c, int d)
{
   s[f][0] = a;
   s[f][1] = b;
   s[f][2] = c;
   s[f][3] = d;
   f++;
}

void add_square(int x, int z)
{
   int i, j, k, l;
   i = add_pt(x * D, z * D);
   j = add_pt(x * D + W, z * D);
   k = add_pt(x * D + W, z * D + W);
   l = add_pt(x * D, z * D + W);
   add_square4(i, j, k, l);
}

int main()
{
   int x, z;
   int i;
   for (x=-N; x<=N; x++)
   {
      for (z=-N; z<=N; z++)
      {
//         if ((x & 1) && ((x + (z & 1)) & 1))
//         {
            add_square(x, z);
//         }
      }
   }
   printf("ground %d %d\n", n, f);
   for (i=0; i<n; i++)
   {
      printf("%d %d %d\n", px[i], rand() % 100, pz[i]);
   }
   for (i=0; i<f; i++)
   {
      if (i & 1)
         printf("0x%x 4 %d %d %d %d\n", 0x125, s[i][0], s[i][1], s[i][2], s[i][3]);
      else
         printf("0x%x 4 %d %d %d %d\n", 0x225, s[i][0], s[i][1], s[i][2], s[i][3]);
   }
   return 0;
}

