/*

NanoTech - a 3d game engine
Copyright (C) 1996  Sean Lane Fuller

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Sean Lane Fuller
124 Autumn Lane
Tullahoma, TN 37388
615-393-4550
email: fuller@edge.net

*/

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include "keyboard.h"

static char already_installed=0;
volatile char  key;
volatile char  keys[128];
void (_interrupt * old_keyboard_isr)();

void _interrupt new_keyboard_isr(void)
{
   register char temp;
   key = inp( 0x60);
   temp = inp(0x61) | 0x82;
   outp( 0x61, temp );
   temp &= 0x7F;
   outp( 0x61, temp);
   if ((key & 0x80)) {              // key down
      keys[ (key & 0x7F)] = 0;            
   }
   else {                           // key up
      keys[key] = 1;
   }
   outp( 0x20, 0x20);
}

void    InitKey(){
    if (already_installed) return;
    old_keyboard_isr = _dos_getvect(0x09);
    _dos_setvect(0x09, new_keyboard_isr);
    memset( &keys[0], 0, sizeof(keys) );
    already_installed = 1;
}

void    UninstallKey(){
    if (!already_installed) return;
    _dos_setvect(0x09, old_keyboard_isr);
    already_installed = 0;
}                
