/*

NanoTech - a 3d game engine
Copyright (C) 1996  Sean Lane Fuller

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Sean Lane Fuller
124 Autumn Lane
Tullahoma, TN 37388
615-393-4550
email: fuller@edge.net

*/

#define CHARBKGD 8
#define CHARFGD 0x6f
typedef float fixed;
extern int background;
void tunnel();
void pix_loadpcx(char *buffer, char *filename, int setup_palette);
void pix_fx1();
void pix_disp_char(int c, unsigned int x, unsigned int y, int fgd, int bkgd);
void pix_disp_str(char *s, int x, int y, int fgd, int bkgd);
void pix_upd_mouse();
void pix_setup_palette(float f);
void pix_pset(int x, int y, int color);
void pix_init();
void pix_border();
void pix_refresh();
void pix_term();
void pix_cls(int color);
void pix_poly( int vert_x[], int vert_y[], fixed vert_z[], int no_verts, int color,
      fixed u[], fixed v[]);
void pix_per_poly( int vert_x[], int vert_y[], fixed vert_z[], int no_verts, int color,
      fixed u[], fixed v[]);
void pix_horiz_poly( int vert_x[], int vert_y[], fixed vert_z[], int no_verts, int color,
      fixed u[], fixed v[]);
void pix_wire( int vert_x[], int vert_y[], int no_verts, int color);
void pix_line( int x1, int y1, int x2, int y2, short color);
void pix_lineclip( int x1, int y1, int x2, int y2, short color);
void pix_pop_msg(char *msg, int fgd, int bkgd);
int pix_pop_yn(char *msg, int fgd, int bkgd);
void pix_pulldown();
void pix_pullup();
extern char flash;

#define MAXNUMXPIXELS 1024
#define MAXNUMYPIXELS 768

//#define VIDMODE _URES256COLOR
//#define MAXX (640-1)
//#define MAXY (400-1)

//#define VIDMODE _MRES256COLOR
//#define MAXX (320-1)
//#define MAXY (200-1)

//#define VIDMODE _XRES256COLOR
//#define MAXX (1024-1)
//#define MAXY (768-1)

//#define MIDX (MAXX/2)
//#define MIDY (MAXY/2)
//#define NUMXPIXELS (MAXX+1)
//#define NUMYPIXELS (MAXY+1)

extern int MAXX, MAXY, NUMXPIXELS, NUMYPIXELS, MIDX, MIDY, VIDMODE, CLIPMAXX, CLIPMAXY;
