/*

NanoTech - a 3d game engine
Copyright (C) 1996  Sean Lane Fuller

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Sean Lane Fuller
124 Autumn Lane
Tullahoma, TN 37388
615-393-4550
email: fuller@edge.net

*/

#include "pix.h"
//#define TMAPH 0x40
//#define TMAPW 0x40
//#define TSHIFT 6
#define TMAPH 0x100
#define TMAPW 0x100
#define TSHIFT 8

void init_textures();

#define MAX_POLY_VERTS      8       // after clip

typedef struct {
    float   x, y, z, u, v;
} point2D_t;

typedef struct {
    int         num_verts;
    point2D_t   verts[MAX_POLY_VERTS];
} polygon2D_t;

void ClearEdgeLists();
void AddPolygonEdges(polygon2D_t *screenpoly, int color);
void ScanEdges();
void DrawSpans();

