/*

NanoTech - a 3d game engine
Copyright (C) 1996  Sean Lane Fuller

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Sean Lane Fuller
124 Autumn Lane
Tullahoma, TN 37388
615-393-4550
email: fuller@edge.net

*/

#include "timer.h"
#include <i86.h>
#include <dos.h>
#include <conio.h>

#define TIMER_INT 0x1c

void (_interrupt * Old_Timer_Isr)();

int clock_tick = 0;
int timer_tick = 0;

void _interrupt New_Timer_Int(void)
{
   clock_tick++;
   timer_tick++;
  _chain_intr(Old_Timer_Isr);
}

void Init_Timer() {
   clock_tick = timer_tick = 0;
   Old_Timer_Isr = _dos_getvect(TIMER_INT);
   _dos_setvect(TIMER_INT, New_Timer_Int);
}

void Close_Timer() {
   _dos_setvect(TIMER_INT, Old_Timer_Isr);
}
