/*

NanoTech - a 3d game engine
Copyright (C) 1996  Sean Lane Fuller

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Sean Lane Fuller
124 Autumn Lane
Tullahoma, TN 37388
615-393-4550
email: fuller@edge.net

*/


#include <dos.h>
#include <process.h>
#include <conio.h>
#include <math.h>
#include <stdio.h>

#define   CONE_SIZE_Y    180.0
#define   CONE_SIZE_X    205.0
#define   CONE_SIZE_Z    8000.0
int i, j;
char texture_buffer[0xffff];
unsigned short texture_lut[64000];
char texture_adj[64000];
unsigned char vram_buffer[64000];

unsigned char *VRAM = (unsigned char *)0xa0000;
unsigned int idx1, velocity;
int a, n, sx, sy, tx, ty, c;
float theta, x, y, u, v, tempx, tempy, tempz;

void mymemcopy( unsigned char* dst, unsigned char *src, int size );
#pragma aux mymemcpy = \
    "shr ecx, 2" \
    "rep movsd" \
    parm [edi][esi][ecx];

void warp()
{  
   int i, countdown, phase=0;
//   memset(vram_buffer, 0, 64000);
//   memcpy((char *)0xa0000, vram_buffer, 64000);
   load_data();
   set_warp_palette();
   idx1=0x1000;
   velocity = 0x702;
   while (phase != 3) {
      while(phase != 3) {
         do_fire();
         warpx();
         switch (phase)
         {
         case 0:
            if (idx1 >= 0xae00) {
               velocity = 0;
               countdown = 35; 
               phase = 1;
            }
            break;
         case 1:
            countdown--;
            if (countdown <= 0) {
               phase = 2;
               velocity = 0x303;
               countdown = 27;
            }
            break;
         case 2:
            countdown--;
            if (countdown <= 0)
            {
               phase = 3;
            }
            break;
         }
      }
   }
//   memset(vram_buffer, 0, 64000);
//   memcpy((char *)0xa0000, vram_buffer, 64000);
}

void set_warp_palette()
{
   int dx = 0x3c8, bx = 0;
   float cx;
   union REGS r;
   unsigned int i;
return;
//   r.h.ah = 0x00;
//   r.h.al = 0x13;
//   int386(0x10, &r, &r);
   for (cx=0; cx<256; cx++) {
      outp(dx, bx);
      dx++;
      outp(dx, ((int)(cx * .2) & 0x7f));
      outp(dx, 0);
      outp(dx, ((int)(cx * .25) & 0x7f));
      dx--;
      bx++;
   }
}

#define BUF_WIDTH 256
#define BUF_HEIGHT 256
void do_fire()
{
   unsigned int i, j;
   unsigned int delta;
      // Transform current buffer
      for (i=BUF_WIDTH; i<BUF_HEIGHT *  BUF_WIDTH; i++)
      {
         if (i > BUF_HEIGHT * BUF_WIDTH - BUF_WIDTH)
            texture_buffer[i - BUF_WIDTH] =
               (texture_buffer[i] + texture_buffer[i-1]
               + texture_buffer[i+1]) >> 1;
         else
            texture_buffer[i - BUF_WIDTH] =
               (texture_buffer[i] + texture_buffer[i-1]
               + texture_buffer[i+1] + texture_buffer[i+BUF_WIDTH]) >> 2;
         if (texture_buffer[i] > 18) texture_buffer[i] -= 3;
         else if (texture_buffer[i] > 0) texture_buffer[i]--;
//         else if (texture_buffer[i] > 3) texture_buffer[i] -= 1;
//         else if (texture_buffer[i] != 0) texture_buffer[i] = 0;
      }
      delta = 0;
      for(j=0;j<BUF_WIDTH;j++) {
         if(rand() % 50 < 20) {
            delta=255;
         }
         else delta = 0;
//         delta = rand() % 256;
         texture_buffer[(BUF_HEIGHT - 2) * BUF_WIDTH + j] = delta;
         texture_buffer[(BUF_HEIGHT - 1) * BUF_WIDTH + j] = delta;
      }
}

void load_data()
{
   int i;
   FILE *fp;
   memset(texture_buffer, 0, 65535);
   fp = fopen("lut.dat", "rb");
   if (fp == NULL) {
      build_lut(); save_lut();
   }
   else {
      fread(texture_lut, sizeof(short), 64000, fp);
      fread(texture_adj, sizeof(char), 64000, fp);
      fclose(fp);
   }
}

void save_lut()
{
   FILE *fp = fopen("lut.dat", "wb");
   if (fp == NULL) return;
   fwrite(texture_lut, sizeof(short), 64000, fp);
   fwrite(texture_adj, sizeof(char), 64000, fp);
   fclose(fp);
}

void build_lut()
{
   int flipper = 0;
   float    step_y,step_x,noise;
   step_y = 0;
   step_x = 0;
   for (i=0; i<64000; i++) texture_adj[i] = 255;
   for (i=0; i<64000; i++) texture_lut[i] = 0;
   memset(vram_buffer, 0, 64000);
   for(y=100.0; y>0; y-=step_y) {
      v = y / 100.0;
      ty = y / 100.0 * BUF_HEIGHT;
      step_y = 0.01 + (0.10 * y / 100);
      for(x=100.0; x>0; x-=step_x) {
         step_x = 0.01 + (0.10 * y/100);
         tx = x/100.0 * BUF_WIDTH;
         u = x/100.0;
         theta = u * 360.0 * 0.01745329;
         idx1 = ty * BUF_WIDTH + tx;
         tempx = CONE_SIZE_X * cos(theta);
         tempy = CONE_SIZE_Y * sin(theta);
         tempz = CONE_SIZE_Z * v;
         sx = tempx * CONE_SIZE_X/(tempz + CONE_SIZE_X) + 160;
         sy = tempy * CONE_SIZE_Y/(tempz + CONE_SIZE_Y) + 100;
         if(sy<200 && sy>=0 && sx<320 && sx>=0) {
            if (++flipper > 25000) { warpx(); flipper = 0; }
            texture_lut[sy * 320 + sx] = idx1;
            texture_adj[sy * 320 + sx] = sqrt(v) * 256.0;
         }
      }
   }
}

void warpx()
{
   int i, j;
   int wrap = 0;
   unsigned char c;
   extern char background_texture[320 * 200];
   unsigned char d;
   for (i=0; i<64000; i++) {
      j = (int)texture_lut[i] + idx1;
      if (j >= 65535) { j -= 65535; wrap = 1; } else wrap = 0;
      c = texture_buffer[j];
      d = texture_adj[i];
      if (d > 220 || wrap) c = 0;
      if (j > 0xfa00 && d <= 220) c = texture_buffer[0xfa00 - (j - 0xfa00)];
      if (c == 0) c = background_texture[i];
      vram_buffer[i] = c;
   }
   idx1 += velocity;
   if (idx1 >= 65535) idx1 -= 65535;
   do { i = inp(0x3da); } while (!(i & 0x08));
   mymemcpy(VRAM, vram_buffer, 64000);
}
