/********************************/
/* DNPCTRIS - Anzeigefunktionen */
/********************************/

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include "DEFS.H"
#include "VARS.H"

/* Funktionsprototypen */
void text_info(SPIELER *sp);
void set_feld_koords(SPIELER *sp);
void zeichne_spielfeld();
void zeige_stein(SPIELER *sp);
int box_art(int x, int y, SPIELER *sp, BOOLEAN feld);
void zeige_kaestchen(SPIELER *sp, int x, int y);

extern void spieler_tasten();

/* Funktionen */
void text_info(SPIELER *sp)
{
	char txt[80], str[20];

	if(anz_spieler == 1)
	{
		put_text(&schrift, schrift.char_w * 3, schrift.char_h, "DN - PCTRIS");
		strcpy(txt, "POINTS: ");
		itoa(sp->punkte, str, 10);
		strcat(txt, str);
		put_text(&schrift, schrift.char_w * 3, schrift.char_h * 3, txt);
		strcpy(txt, "LEVEL: ");
		itoa(sp->level, str, 10);
		strcat(txt, str);
		put_text(&schrift, schrift.char_w * 3, schrift.char_h * 5, txt);
		strcpy(txt, "ROWS: ");
		itoa(sp->reihen, str, 10);
		strcat(txt, str);
		put_text(&schrift, schrift.char_w * 3, schrift.char_h * 7, txt);

		if(spieler[0].steuern == spieler_tasten)
		{	
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h , "CONTROL KEYS");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 3, "ESC - QUIT");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 5, "LEFT - LEFT");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 7, "RIGHT - RIGHT");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 9, "DOWN - ROTATION");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 11, "RCTRL - DROP");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 13, "F1 - CHANGE");
		}
		else
		{	
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h , "CONTROL KEYS");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 3, "ESC - QUIT");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 5, "LEFT - LEFT");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 7, "RIGHT - RIGHT");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 9, "UP - ROTATION");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 11, "DOWN - DROP");
			put_text(&schrift, feld_start_x + FELD_W * steingroesse + schrift.char_w * 3, schrift.char_h * 13, "F1 - CHANGE");
		}
	}
	else
	{
		put_text(&schrift, screen_width / 2 - schrift.char_w * 3, schrift.char_h, "PCTRIS");
		strcpy(txt, "PTS:");
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 2, txt);
		itoa(spieler[0].punkte, txt, 10);
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 3, txt);
		strcpy(txt, "LVL:");
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 4, txt);
		itoa(spieler[0].level, txt, 10);
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 5, txt);
		strcpy(txt, "ROWS:");
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 6, txt);
		itoa(spieler[0].reihen, txt, 10);
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 7, txt);

		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 9, "CTRL");
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 10, "A");
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 11, "D");
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 12, "LCT");
		put_text(&schrift, schrift.char_w * 1, schrift.char_h * 13, "S");

		strcpy(txt, "PTS:");
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 2, txt);
		itoa(spieler[1].punkte, txt, 10);
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 3, txt);
		strcpy(txt, "LVL:");
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 4, txt);
		itoa(spieler[1].level, txt, 10);
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 5, txt);
		strcpy(txt, "ROWS:");
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 6, txt);
		itoa(spieler[1].reihen, txt, 10);
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 7, txt);

		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 9, "CTRL");
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 10, "LEFT");
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 11, "RIGHT");
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 12, "RCT");
		put_text(&schrift, screen_width - schrift.char_w * 5, schrift.char_h * 13, "DOWN");
	}
}

void set_feld_koords(SPIELER *sp)
{
	if(anz_spieler == 1)
	{
		feld_start_x = FELD_STARTX;
		feld_start_y = FELD_STARTY;
	}
	else if(sp->nr == 0)
	{
		feld_start_x = FELD1_STARTX;
		feld_start_y = FELD1_STARTY;
	}
	else
	{
		feld_start_x = FELD2_STARTX;
		feld_start_y = FELD2_STARTY;
	}

	if(gfxmode == 0x13)
		steingroesse = 10;
	else
	{
		steingroesse = 20;
		feld_start_x *= 2;
		feld_start_y *= 2;
	}
}

void zeichne_spielfeld()
{
	int x, y, i;

	putvollbild(hintergrund);

	for(i = 0; i < anz_spieler; i++)
	{
		set_feld_koords(&spieler[i]);

		for(x = 0; x < FELD_W; x++)
			for(y = 0; y < FELD_H; y++)
				zeige_kaestchen(&spieler[i], x, y);

		text_info(&spieler[i]);
	}
}

void zeige_stein(SPIELER *sp)
{
	int x, y, pixnr, px, py;

	set_feld_koords(sp);

	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			if(sp->fallstein.stein[x][y])
			{
				pixnr = box_art(x, y, sp, FALSE);

				px = feld_start_x + (x + sp->fallstein.x) * steingroesse;
				py = feld_start_y + (y + sp->fallstein.y) * steingroesse;
				put(px, py, &steinpix[sp->fallstein.color][pixnr]);
			}
}

int box_art(int x, int y, SPIELER *sp, BOOLEAN feld)
{
	int pixnr, color;

	if(feld)
	{
		if(sp->feld[x][y] == 0)
			return(0);

		color = sp->feld[x][y];
		pixnr = 0;
		if((y == 0) || (sp->feld[x][y - 1] != color))
			pixnr += 1;
		if((x == FELD_W - 1) || (sp->feld[x + 1][y] != color))
			pixnr += 2;
		if((y == FELD_H - 1) || (sp->feld[x][y + 1] != color))
			pixnr += 4;
		if((x == 0) || (sp->feld[x - 1][y] != color))
			pixnr += 8;
	}
	else
	{
		color = sp->fallstein.color;
		pixnr = 0;
		if((y == 0) || !sp->fallstein.stein[x][y - 1])
			pixnr += 1;
		if((x == 3) || !sp->fallstein.stein[x + 1][y])
			pixnr += 2;
		if((y == 3) || !sp->fallstein.stein[x][y + 1])
			pixnr += 4;
		if((x == 0) || !sp->fallstein.stein[x - 1][y])
			pixnr += 8;
	}

	return(pixnr);
}

void zeige_kaestchen(SPIELER *sp, int x, int y)
{
	int pixnr, px, py;

	pixnr = box_art(x, y, sp, TRUE);

	px = feld_start_x + x * steingroesse;
	py = feld_start_y + y * steingroesse;
	put(px, py, &steinpix[sp->feld[x][y]][pixnr]);
}
