/*********************************/
/* PCTRIS - Highscoreroutinen    */
/*********************************/

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include <key.h>
#include "DEFS.H"
#include "VARS.H"

#define HSCREINTRAEGE 10

/* globale Variablen */
struct
{
	int punkte;
	int level;
	int reihen;
	char name[30];
} hscr_eintrag[HSCREINTRAEGE];

BOOLEAN key_pressed;

/* Funktionsprototypen */
void highscore(void);

/*  Funktionen */
void highscore_load(void)
{
	FILE *datei;
	int i;

	datei = fopen("HISCORE.DAT", "rb");
	if(!datei)
	{
		/* neu erzeugen */
		datei = fopen("HISCORE.DAT", "wb");
		for(i = 0; i < HSCREINTRAEGE; i++)
		{
			hscr_eintrag[i].punkte = 1000 - i * 50;
			hscr_eintrag[i].level = 0;
			hscr_eintrag[i].reihen = 0;
			strcpy(hscr_eintrag[i].name, "NOONE");
		}
		fwrite(hscr_eintrag, sizeof(hscr_eintrag[0]), HSCREINTRAEGE, datei);
		fclose(datei);
	}
	else
	{
		fread(hscr_eintrag, sizeof(hscr_eintrag[0]), HSCREINTRAEGE, datei);
		fclose(datei);
	}
}

void highscore_save(void)
{
	FILE *datei;

	datei = fopen("HISCORE.DAT", "wb");
	if(datei)
	{
		fwrite(hscr_eintrag, sizeof(hscr_eintrag[0]), HSCREINTRAEGE, datei);
		fclose(datei);
	}
}

void get_string(char *str)
{
	if(keyTest(KEY_A))
	{
		if(!key_pressed)
			strcat(str, "A");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_B))
	{
		if(!key_pressed)
			strcat(str, "B");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_C))
	{
		if(!key_pressed)
			strcat(str, "C");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_D))
	{
		if(!key_pressed)
			strcat(str, "D");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_E))
	{
		if(!key_pressed)
			strcat(str, "E");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_F))
	{
		if(!key_pressed)
			strcat(str, "F");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_G))
	{
		if(!key_pressed)
			strcat(str, "G");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_H))
	{
		if(!key_pressed)
			strcat(str, "H");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_I))
	{
		if(!key_pressed)
			strcat(str, "I");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_J))
	{
		if(!key_pressed)
			strcat(str, "J");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_K))
	{
		if(!key_pressed)
			strcat(str, "K");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_L))
	{
		if(!key_pressed)
			strcat(str, "L");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_M))
	{
		if(!key_pressed)
			strcat(str, "M");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_N))
	{
		if(!key_pressed)
			strcat(str, "N");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_O))
	{
		if(!key_pressed)
			strcat(str, "O");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_P))
	{
		if(!key_pressed)
			strcat(str, "P");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_Q))
	{
		if(!key_pressed)
			strcat(str, "Q");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_R))
	{
		if(!key_pressed)
			strcat(str, "R");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_S))
	{
		if(!key_pressed)
			strcat(str, "S");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_T))
	{
		if(!key_pressed)
			strcat(str, "T");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_U))
	{
		if(!key_pressed)
			strcat(str, "U");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_V))
	{
		if(!key_pressed)
			strcat(str, "V");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_W))
	{
		if(!key_pressed)
			strcat(str, "W");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_X))
	{
		if(!key_pressed)
			strcat(str, "X");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_Y))
	{
		if(!key_pressed)
			strcat(str, "Y");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_Z))
	{
		if(!key_pressed)
			strcat(str, "Z");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_SPACE))
	{
		if(!key_pressed)
			strcat(str, " ");
		key_pressed = TRUE;
	}
	else if(keyTest(KEY_BACKSPACE))
	{
		if(!key_pressed)
			if(strlen(str) > 0)
				str[strlen(str) - 1] = 0;
		key_pressed = TRUE;
	}
	else
		key_pressed = FALSE;
}

void highscore_eintragen(void)
{
	int i, pos;
	long t;

	pos = -1;
	for(i = 0; i < HSCREINTRAEGE; i++)
		if(hscr_eintrag[i].punkte < spieler[0].punkte)
		{
			pos = i;
			break;
		}

	if(pos != -1)
	{
		// alte runterkopieren
		for(i = HSCREINTRAEGE - 2; i >= pos; i--)
			hscr_eintrag[i + 1] = hscr_eintrag[i];

		hscr_eintrag[pos].punkte = spieler[0].punkte;
		hscr_eintrag[pos].level = spieler[0].level;
		hscr_eintrag[pos].reihen = spieler[0].reihen;
		strcpy(hscr_eintrag[pos].name, "");
		// und Eingabe
		key_pressed = FALSE;
		t = timer();
		do
		{
			if(timer() - t > 0)
			{
				t = timer();

				get_string(hscr_eintrag[pos].name);
				putvollbild(hintergrund);
				put_text(&schrift, screen_width / 4, screen_height / 2 - 1 * schrift.char_h, "HISCORE - ENTER YOUR NAME");
				put_text(&schrift, screen_width / 4, screen_height / 2 + 1 * schrift.char_w, hscr_eintrag[pos].name);

				Copy2Screen();
			}
		}
		while(!keyTest(KEY_ENTER));
	}
}

void highscore_put(void)
{
	int i;
	char txt[80], str[10];

	for(i = 0; i < HSCREINTRAEGE; i++)
	{
		itoa(i + 1, str, 10);
		strcpy(txt, str);
		strcat(txt, ". ");
		itoa(hscr_eintrag[i].punkte, str, 10);
		strcat(txt, str);
		strcat(txt, " PUNKTE, ");
		itoa(hscr_eintrag[i].level, str, 10);
		strcat(txt, str);
		strcat(txt, ". LEVEL, ");
		itoa(hscr_eintrag[i].reihen, str, 10);
		strcat(txt, str);
		strcat(txt, " REIHEN, ");
		strcat(txt, hscr_eintrag[i].name);
		put_text(&schrift, screen_width / 2 - strlen(txt) * schrift.char_w / 2, screen_height / 2 - HSCREINTRAEGE * schrift.char_h + i * 2 * schrift.char_h, txt);
	}
}

void highscore(void)
{
	long t;

	while(keyTest(KEY_ENTER) || keyTest(KEY_ESC) || keyTest(KEY_SPACE))
		;

	highscore_load();

	highscore_eintragen();
	while(keyTest(KEY_ENTER))
		;

	t = timer();
	do
	{
		if(timer() - t > 0)
		{
			t = timer();

			putvollbild(hintergrund);
			highscore_put();
			Copy2Screen();
		}
	}
	while(!keyTest(KEY_ESC) && !keyTest(KEY_ENTER) && !keyTest(KEY_SPACE));

//	if(keyTest(KEY_ESC))
//		ende = TRUE;

	highscore_save();

	while(keyTest(KEY_ENTER) || keyTest(KEY_ESC) || keyTest(KEY_SPACE))
		;
}
