/*************************************/
/* DN PCTRIS - Initialisierung, Exit */
/*************************************/

#include <stdlib.h>
#include <i86.h>
#include <dn.h>
#include "DEFS.H"
#include "VARS.H"

/* Funktionsprototypen */
BOOLEAN spiel_init(int gfx);
void spiel_exit();
void spiel_reset();
void pause(long time);
void dn_intro(BYTE sounddevice);

extern void neuer_fallstein(SPIELER *sp);
extern void spieler_tasten(int nr);
extern void spieler_cursortasten(int nr);
extern void spieler_buchstaben(int nr);
extern void spieler_buchstaben_control(int nr);

extern void zeichne_spielfeld();

/* Funktionen */
BOOLEAN spiel_init(int gfx)
{
	int i, z;

	if(!init_gfx(0x13))
	{
		exit_sound();
		puts("Graphixinit-error!\n");
		return(FALSE);
	}

	/* DN-Vorspann */
//	dn_intro(4);	// sounddevice 4 = nosound
//	stop_sound();
//	exit_sound();

	load_font("FONT.PIX", 0, ' ', 6, 6, &schrift);
	if(grafixmode == 0x100)
	{
		schrift.char_w *= 2;
		schrift.char_h *= 2;
	}

	set_mode(grafixmode);

	keyInstall();

	hintergrund = malloc(screen_width * screen_height);
	if(gfxmode == 0x13)
	{
		load_pic("STEINE.PIX", screen_addr, alt_rgb);
		get(0, 190, 9, 199, &steinpix[0][0]);
		for(i = 0; i < STEINARTEN; i++)
			for(z = 0; z < 17; z++)
				get(z * 10, i * 10, z * 10 + 9, i * 10 + 9, &steinpix[i + 1][z]);
		get(0, 70, 80, 140, &gameoverpix);
	}
	else
	{
		load_pic("STEINES.PIX", screen_addr, alt_rgb);
		get(0, 380, 19, 399, &steinpix[0][0]);
		for(i = 0; i < STEINARTEN; i++)
			for(z = 0; z < 17; z++)
				get(z * 20, i * 20, z * 20 + 19, i * 20 + 19, &steinpix[i + 1][z]);
		get(0, 140, 160, 280, &gameoverpix);
	}

	anz_spieler = 1;

	return(TRUE);
}

void spiel_exit()
{
	int i, z;

	for(i = 0; i < STEINARTEN; i++)
		for(z = 0; z < 17; z++)
			free(steinpix[i][z].mem);
	free(gameoverpix.mem);

	keyRemove();

	free(hintergrund);

	exit_gfx();
}

void spiel_reset()
{
	int x, y, i;

	if(gfxmode == 0x13)
		load_pic("HINTER.PIX", hintergrund, spielpal);
	else
		load_pic("HINTERS.PIX", hintergrund, spielpal);

	srand((int)timer());

	for(i = 0; i < anz_spieler; i++)
	{
		spieler[i].nr = i;
		spieler[i].punkte = 0;
		spieler[i].reihen = 0;
		spieler[i].starthoehe = 0;
		spieler[i].level = 0;

		if(anz_spieler == 1)
			spieler[i].steuern = spieler_tasten;
		else if(i == 0)
			spieler[i].steuern = spieler_buchstaben_control;
		else
			spieler[i].steuern = spieler_tasten;

		for(y = 0; y < FELD_H; y++)
			for(x = 0; x < FELD_W; x++)
				spieler[i].feld[x][y] = 0;

		neuer_fallstein(&spieler[i]);
	}

	spieler[0].gameover = 100;
	spieler[1].gameover = 100;

	zeichne_spielfeld();
	Copy2Screen();
	SetPalette(spielpal);
}

void pause(long time)
{
	long t;

	t = timer();
	while(timer() - t < time)
	{
		play_sound();
		delay(10);
	}
}

void dn_intro(BYTE sounddevice)
{
	RGB dnpal[256];
	void *dnpix;
	RGB blitzpal[2][256];
	void *blitzpix[2];
	SAMPLE *donner;

	if(alt_pressed())
		return;

	dnpix = malloc(64000);
	blitzpix[0] = malloc(64000);
	blitzpix[1] = malloc(64000);

	if(!init_sample("DONNER.WAV", &donner, sounddevice, 3))
	{
		exit_gfx();
		puts("Sound-Initialization: ERROR\n");
		exit(-1);
	}

	cls(0);
	load_pic("DNIGHT.PIX", dnpix, dnpal);
	load_pic("BLITZ1.PIX", blitzpix[0], blitzpal[0]);
	load_pic("BLITZ2.PIX", blitzpix[1], blitzpal[1]);

	/* DN */
	ClearPalette(alt_rgb);
	putvollbild(dnpix);
	Copy2Screen();
	PaletteFadeIn(dnpal);
	pause(100);

	/* Blitz 1 */
	putvollbild(blitzpix[0]);
	Copy2Screen();
	SetPalette(blitzpal[0]);
	start_sample(donner, 0);
	pause(15);

	/* DN */
	putvollbild(dnpix);
	SetPalette(dnpal);
	Copy2Screen();
	pause(300);

	/* Blitz 2 */
	putvollbild(blitzpix[1]);
	Copy2Screen();
	SetPalette(blitzpal[1]);
	start_sample(donner, 1);
	start_sample(donner, 2);
	pause(15);

	/* DN */
	putvollbild(dnpix);
	SetPalette(dnpal);
	Copy2Screen();
	pause(500);

	free_sample(donner);

	free(blitzpix[1]);
	free(blitzpix[0]);
	free(dnpix);

	stop_sound();

	PaletteFadeOut(dnpal);
}
