/*****************************************/
/* DN PCTRIS                             */
/* Written on 9 May 1996 by Michael Haar */
/*****************************************/

#include <stdlib.h>
#include <string.h>
#include <dn.h>
#include <key.h>
#include "DEFS.H"

/* globale Variablen */
int grafixmode;
BOOLEAN spielsound;
BOOLEAN ende;
SPIELER spieler[2];
FALLSTEIN fallstein;
void *hintergrund;
int anz_spieler;
GFXBLK steinpix[STEINARTEN + 1][17];
RGB spielpal[256];
GFXBLK gameoverpix;
int steingroesse, feld_start_x, feld_start_y;

/* Funktionsprototypen */
void commandline(int argc, const char *argv[]);
void steuern_umschalten();
void titel();

extern BOOLEAN spiel_init(int gfx);
extern void spiel_exit();
extern void spiel_reset();

extern void neuer_fallstein(SPIELER *sp);
extern BOOLEAN stein_fallen(SPIELER *sp);
extern BOOLEAN setze_stein(SPIELER *sp);
extern void dreh_fallstein(SPIELER *sp);
extern void wirf_fallstein(SPIELER *sp);
extern void fallstein_rechts(SPIELER *sp);
extern void fallstein_links(SPIELER *sp);
void spieler_tasten(int nr);
void spieler_cursortasten(int nr);
void spieler_buchstaben(int nr);
void spieler_buchstaben_control(int nr);

extern void set_feld_koords(SPIELER *sp);
extern void zeichne_spielfeld();
extern void zeige_stein(SPIELER *sp);

extern void highscore();

/* Funtionen */
void commandline(int argc, const char *argv[])
{
	int i;

	grafixmode = 0x13;
	joystick = FALSE;
	spielsound = TRUE;

	for(i = 0; i < argc; i++)
	{
		if(!strcmp(argv[i], "-svga"))
			grafixmode = 0x100;
		else if(!strcmp(argv[i], "-joystick"))
			joystick = TRUE;
		else if(!strcmp(argv[i], "-nosound"))
			spielsound = FALSE;
	}
}

void steuern_umschalten()
{
	if(anz_spieler == 1)
	{
		if(keyTest(KEY_F1))
		{
			if(spieler[0].steuern == spieler_cursortasten)
				spieler[0].steuern = spieler_tasten;
			else
				spieler[0].steuern = spieler_cursortasten;
			while(keyTest(KEY_F1))
				;
		}
	}
	else
	{
		if(keyTest(KEY_F2))
		{
			if(spieler[0].steuern == spieler_cursortasten)
				spieler[0].steuern = spieler_tasten;
			else
				spieler[0].steuern = spieler_cursortasten;
			while(keyTest(KEY_F2))
				;
		}
		else if(keyTest(KEY_F1))
		{
			if(spieler[1].steuern == spieler_buchstaben)
				spieler[1].steuern = spieler_buchstaben_control;
			else
				spieler[1].steuern = spieler_buchstaben;
			while(keyTest(KEY_F1))
				;
		}
	}
}

void titel()
{
	GFXBLK titeltxtpix;
	void *titelpix;
	int pos;

	if(gfxmode == 0x13)
	{
		load_pic("PCTRIS.PIX", screen_addr, alt_rgb);
		get(0, 0, 300, 120, &titeltxtpix);
		titelpix = malloc(screen_width * screen_height);
		load_pic("TITEL.PIX", titelpix, alt_rgb);
		pos = -120;
	}
	else
	{
		load_pic("PCTRISS.PIX", screen_addr, alt_rgb);
		get(0, 0, 600, 240, &titeltxtpix);
		titelpix = malloc(screen_width * screen_height);
		load_pic("TITELS.PIX", titelpix, alt_rgb);
		pos = -240;
	}
	SetPalette(alt_rgb);
	do
	{
		if(pos < 0)
			pos += 2;
		putvollbild(titelpix);
		if(gfxmode == 0x13)
		{
			objput(5, pos, &titeltxtpix);
			put_text(&schrift, 30, 180, "PRESS 1 FOR ONE PLAYER - 2 FOR TWO PLAYER");
		}
		else
		{
			objput(10, pos, &titeltxtpix);
			put_text(&schrift, 60, 360, "PRESS 1 FOR ONE PLAYER - 2 FOR TWO PLAYER");
		}
		Copy2Screen();
	}
	while(!keyTest(KEY_SPACE) && !keyTest(KEY_ESC) && !keyTest(KEY_ENTER) && !keyTest(KEY_1) && !keyTest(KEY_2));
	if(keyTest(KEY_1))
		anz_spieler = 1;
	else if(keyTest(KEY_2))
		anz_spieler = 2;
	else if(keyTest(KEY_ESC))
		ende = TRUE;
	else
		ende = FALSE;
	while(keyTest(KEY_SPACE) || keyTest(KEY_ENTER) || keyTest(KEY_1) || keyTest(KEY_2))
		;

	free(titelpix);
	free(titeltxtpix.mem);
}

/* Hauptprogramm */
int main(int argc, const char *argv[])
{
	long t;
	int fallen, i;

	commandline(argc, argv);

	if(!spiel_init(grafixmode))
	{
		puts("ERROR during initialisation!\7");
		return(-1);
	}

	while(!ende)
	{
		titel();

// save_pic("PCTRISTI.PCX", screen_addr, alt_rgb);
	
		spiel_reset();
	
		t = timer();
		fallen = 9 - spieler[0].level;
		while((spieler[0].gameover > 0) && (spieler[1].gameover > 0) && !ende)
		{
			if(timer() - t > 0)
			{
				t = timer();

				if(keyTest(KEY_ESC))
				{
					while(keyTest(KEY_ESC))
						;
					spieler[0].gameover = 0;
					spieler[1].gameover = 0;
				}
				if(keyTest(KEY_P))
				{
					put_text(&schrift, screen_width / 2 - 6 * schrift.char_w / 2, screen_height / 2 - schrift.char_h / 2, "PAUSED");
					Copy2Screen();
					while(keyTest(KEY_P))
						;
					while(!keyTest(KEY_SPACE) && !keyTest(KEY_P) && !keyTest(KEY_ESC))
						;
				}

				for(i = 0; i < anz_spieler; i++)
					if(spieler[i].gameover > 99)
						spieler[i].steuern(spieler[i].nr);

				zeichne_spielfeld();

				for(i = 0; i < anz_spieler; i++)
				{
					if(spieler[i].gameover > 99)
						zeige_stein(&spieler[i]);

					if(spieler[i].gameover < 100)
					{
						if(fallen == 1)
							spieler[i].gameover -= 10;

						set_feld_koords(&spieler[i]);
						if(gfxmode == 0x13)
							objput(feld_start_x + 15, feld_start_y + 70, &gameoverpix);
						else
							objput(feld_start_x + 30, feld_start_y + 140, &gameoverpix);
					}
				}

				if(--fallen == 0)
				{
					fallen = 38 - spieler[0].level * 2;
	
					for(i = 0; i < anz_spieler; i++)
						if(spieler[i].gameover > 99)
						{
							if(stein_fallen(&spieler[i]))
							{
								if(setze_stein(&spieler[i]))
									spieler[i].gameover = 99;
								neuer_fallstein(&spieler[i]);
							}
						}
				}
	
				Copy2Screen();

// if(keyTest(KEY_S))
//	save_pic("PCTRISDU.PCX", screen_addr, spielpal);
			}
		}

		if((anz_spieler == 1) && !ende)
			highscore();
	}

	spiel_exit();

	puts("DN PCTRIS - Programming done in May 1996 by Michael Haar, DIGITAL Nightmares.");
	puts("          - Grafix done by Ulrich Haar, DIGITAL Nightmares.\n");
	puts("To contact DIGITAL Nightmares, email to");
	puts("   michael.haar@informatik.uni-oldenburg.de");
	puts("or write to");
	puts("   Michael Haar, Am Schuetzenholz 29, 29643 Neuenkirchen, Germany\n");
	puts("Visit our WWW-hompage:");
	puts("   http://www.informatik.uni-oldenburg.de");
	return(0);
}
