/**************************/
/* PCTRIS - Spielroutinen */
/**************************/

#include <stdlib.h>
#include <dn.h>
#include "DEFS.H"
#include "VARS.H"
#include "STEINE.H"

/* globale Variablen */
BOOLEAN taste_ok[ANZ_SPIELER][4] = { TRUE, TRUE, TRUE, TRUE };

/* Funktionsprototypen */
void neuer_fallstein(SPIELER *sp);
BOOLEAN stein_fallen(SPIELER *sp);
BOOLEAN setze_stein(SPIELER *sp);
void dreh_fallstein(int spnr);
void wirf_fallstein(int spnr);
void fallstein_rechts(int spnr);
void fallstein_links(int spnr);
void reihen_weg(SPIELER *sp);
void entferne_reihe(SPIELER *sp, char ry);
void lege_reihe(SPIELER *sp);
void spieler_tasten(int nr);
void spieler_cursortasten(int nr);
void spieler_buchstaben(int nr);
void spieler_buchstaben_control(int nr);

/* Funktionen */
void neuer_fallstein(SPIELER *sp)
{
	int x, y;

	sp->fallstein.x = FELD_W / 2 - 2;
	sp->fallstein.y = -2;
	sp->fallstein.color = (rand() % STEINARTEN) + 1;
	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			sp->fallstein.stein[x][y] = startstein[sp->fallstein.color - 1][y][x];

	if(stein_fallen(sp))
		sp->gameover = 99;
}

BOOLEAN setze_stein(SPIELER *sp)
{
	char x, y;

	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			if(sp->fallstein.stein[x][y])
				if(y + sp->fallstein.y > -1)
					if(!sp->feld[x + sp->fallstein.x][y + sp->fallstein.y])
						sp->feld[x + sp->fallstein.x][y + sp->fallstein.y] = sp->fallstein.color;
					else
						return(TRUE);

	sp->punkte += sp->level + sp->starthoehe / (FELD_W / 4) + 1;

	reihen_weg(sp);

	return(FALSE);
}

BOOLEAN stein_fallen(SPIELER *sp)
{
	char x, y;

	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			if(sp->fallstein.stein[x][y])
			{
				if(y + sp->fallstein.y + 1 == FELD_H)
					return(TRUE);
				if(sp->feld[x + sp->fallstein.x][y + sp->fallstein.y + 1])
					return(TRUE);
			}

	sp->fallstein.y++;

	return(FALSE);
}

void dreh_fallstein(int spnr)
{
	FALLSTEIN s1, s2;
	char x, y;

	s2 = s1 = spieler[spnr].fallstein;

	/* 90 Grad drehen */
	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			s1.stein[y][x] = spieler[spnr].fallstein.stein[x][y];

	/* spiegeln */
	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			s2.stein[x][3 - y] = s1.stein[x][y];

	/* durfte das so? */
	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			if(s2.stein[x][y])
			{
				if((s2.x + x < 0) || (s2.x + x == FELD_W) || (s2.y + y == FELD_H))
					return;
				if(s2.y + y > -1)
					if(spieler[spnr].feld[s2.x + x][s2.y + y])
						return;
			}

	spieler[spnr].fallstein = s2;
}

void wirf_fallstein(int spnr)
{
	while(!stein_fallen(&spieler[spnr]))
		;
	if(setze_stein(&spieler[spnr]))
		spieler[spnr].gameover = 99;
	else
		neuer_fallstein(&spieler[spnr]);
}

void fallstein_rechts(int spnr)
{
	char x, y;

	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			if(spieler[spnr].fallstein.stein[x][y])
			{
				if(spieler[spnr].fallstein.x + x + 1 == FELD_W)
					return;
				if(spieler[spnr].fallstein.y + y > -1)
					if(spieler[spnr].feld[spieler[spnr].fallstein.x + x + 1][spieler[spnr].fallstein.y + y])
						return;
			}
	spieler[spnr].fallstein.x++;
}

void fallstein_links(int spnr)
{
	char x, y;

	for(x = 0; x < 4; x++)
		for(y = 0; y < 4; y++)
			if(spieler[spnr].fallstein.stein[x][y])
			{
				if(spieler[spnr].fallstein.x + x == 0)
					return;
				if(spieler[spnr].fallstein.y + y > -1)
					if(spieler[spnr].feld[spieler[spnr].fallstein.x + x - 1][spieler[spnr].fallstein.y + y])
						return;
			}
	spieler[spnr].fallstein.x--;
}

void reihen_weg(SPIELER *sp)
{
	int x, y;
	BOOLEAN weg;
	int anz_weg = 0, i;

	for(y = 0; y < 4; y++)
	{
		weg = TRUE;
		for(x = 0; x < FELD_W; x++)
			if(!sp->feld[x][sp->fallstein.y + y])
				weg = FALSE;
		if(weg)
		{
			entferne_reihe(sp, sp->fallstein.y + y);
			if(anz_spieler > 1)
				if(anz_weg > 0)
					for(i = 0; i < anz_spieler; i++)
						if(i != sp->nr)
							lege_reihe(&spieler[i]);
			anz_weg++;
			sp->reihen++;
		}
	}
	sp->punkte += ((sp->level + 1) * 5 + sp->starthoehe * 5) * anz_weg * anz_weg;
	if(anz_weg)
	{
		if(sp->reihen % 5 == 0)
			if(sp->level < 18)
				sp->level++;
	}
}

void entferne_reihe(SPIELER *sp, char ry)
{
	char x, y;

	for(y = ry; y > 0; y--)
		for(x = 0; x < FELD_W; x++)
		{
			sp->feld[x][y] = sp->feld[x][y - 1];
			sp->feld[x][y - 1] = 0;
		}
}

void lege_reihe(SPIELER *sp)
{
	char x, y, xloch;

	for(y = 1; y < FELD_H; y++)
		for(x = 0; x < FELD_W; x++)
			sp->feld[x][y - 1] = sp->feld[x][y];

	xloch = rand() % FELD_W;
	for(x = 0; x < FELD_W; x++)
	{
		if(x != xloch)
			sp->feld[x][FELD_H - 1] = (rand() % STEINARTEN) + 1;
		else
			sp->feld[x][FELD_H - 1] = 0;
	}
}

void spieler_tasten(int nr)
{
	if(keyTest(KEY_LEFT))
	{
		if(taste_ok[nr][0])
		{
			fallstein_links(nr);
			taste_ok[nr][0] = FALSE;
		}
	}
	else
		taste_ok[nr][0] = TRUE;
	if(keyTest(KEY_RIGHT))
	{
		if(taste_ok[nr][1])
		{
			fallstein_rechts(nr);
			taste_ok[nr][1] = FALSE;
		}
	}
	else
		taste_ok[nr][1] = TRUE;
	if(keyTest(KEY_DOWN))
	{
		if(taste_ok[nr][2])
		{
			dreh_fallstein(nr);
			taste_ok[nr][2] = FALSE;
		}
	}
	else
		taste_ok[nr][2] = TRUE;
	if(keyTest(KEY_RCTRL))
	{
		if(taste_ok[nr][3])
		{
			wirf_fallstein(nr);
			taste_ok[nr][3] = FALSE;
		}
	}
	else
		taste_ok[nr][3] = TRUE;
}

void spieler_cursortasten(int nr)
{
	if(keyTest(KEY_LEFT))
	{
		if(taste_ok[nr][0])
		{
			fallstein_links(nr);
			taste_ok[nr][0] = FALSE;
		}
	}
	else
		taste_ok[nr][0] = TRUE;
	if(keyTest(KEY_RIGHT))
	{
		if(taste_ok[nr][1])
		{
			fallstein_rechts(nr);
			taste_ok[nr][1] = FALSE;
		}
	}
	else
		taste_ok[nr][1] = TRUE;
	if(keyTest(KEY_UP))
	{
		if(taste_ok[nr][2])
		{
			dreh_fallstein(nr);
			taste_ok[nr][2] = FALSE;
		}
	}
	else
		taste_ok[nr][2] = TRUE;
	if(keyTest(KEY_DOWN))
	{
		if(taste_ok[nr][3])
		{
			wirf_fallstein(nr);
			taste_ok[nr][3] = FALSE;
		}
	}
	else
		taste_ok[nr][3] = TRUE;
}

void spieler_buchstaben(int nr)
{
	if(keyTest(KEY_A))
	{
		if(taste_ok[nr][0])
		{
			fallstein_links(nr);
			taste_ok[nr][0] = FALSE;
		}
	}
	else
		taste_ok[nr][0] = TRUE;
	if(keyTest(KEY_D))
	{
		if(taste_ok[nr][1])
		{
			fallstein_rechts(nr);
			taste_ok[nr][1] = FALSE;
		}
	}
	else
		taste_ok[nr][1] = TRUE;
	if(keyTest(KEY_W))
	{
		if(taste_ok[nr][2])
		{
			dreh_fallstein(nr);
			taste_ok[nr][2] = FALSE;
		}
	}
	else
		taste_ok[nr][2] = TRUE;
	if(keyTest(KEY_S))
	{
		if(taste_ok[nr][3])
		{
			wirf_fallstein(nr);
			taste_ok[nr][3] = FALSE;
		}
	}
	else
		taste_ok[nr][3] = TRUE;
}

void spieler_buchstaben_control(int nr)
{
	if(keyTest(KEY_A))
	{
		if(taste_ok[nr][0])
		{
			fallstein_links(nr);
			taste_ok[nr][0] = FALSE;
		}
	}
	else
		taste_ok[nr][0] = TRUE;
	if(keyTest(KEY_D))
	{
		if(taste_ok[nr][1])
		{
			fallstein_rechts(nr);
			taste_ok[nr][1] = FALSE;
		}
	}
	else
		taste_ok[nr][1] = TRUE;
	if(keyTest(KEY_S))
	{
		if(taste_ok[nr][2])
		{
			dreh_fallstein(nr);
			taste_ok[nr][2] = FALSE;
		}
	}
	else
		taste_ok[nr][2] = TRUE;
	if(keyTest(KEY_LCTRL))
	{
		if(taste_ok[nr][3])
		{
			wirf_fallstein(nr);
			taste_ok[nr][3] = FALSE;
		}
	}
	else
		taste_ok[nr][3] = TRUE;
}
