#include "wand_head.h"
#include <curses.h>

extern char *playscreen();
extern void helpme();
extern int inform_me();

extern int debug_disp;
extern char *edit_screen;
extern char screen[NOOFROWS][ROWLEN+1];
extern char *edit_memory;
extern char *memory_end;
extern char screen_name[61];
extern WINDOW *displaywin,*mapwin,*infowin,*messagewin;
extern WINDOW *win;

static char *inst[] = { "    O  Boulder",
			"  < >  Arrows",
			"    ^  Balloon",
			"    :  Earth",
			"    !  Landmine",
			"    *  Treasure",
			"  / \\  Deflectors",
			"    +  Cage",
			"_ = #  Rock (# indestructable)",
			"    T  Teleport",
			"    A  Arrival (1 max)",
			"    X  Exit (always 1)",
			"    @  Start (always 1)",
			"    M  Big Monster (1 max)",
			"    S  Baby Monster",
			"    -  Alternative space",
			"    C  Time Capsule",
			"    ~  Thingy",
			"    B  Bomb",
			NULL };

check_legality()
/*
   this will check: baby monster vs cage numbers,
		    teleport, large monster, exit and player numbers
		    hanging boulders/arrows etc
*/
{
    int ercount, cages, hanging, bmons, tele, arrival, you, mons, exits;
    int x, y;
    char buf[80];
    ercount = hanging = cages = bmons = tele = arrival = you = mons = exits = 0;

    move(0,0);
    addstr("Checking screen legality..."); refresh();
    for (x = 0 ; x < ROWLEN ; x++)
	for (y = 0 ; y < NOOFROWS ; y++) {
	    move(y+1,x+1); addch('?'); refresh();
	    switch (screen[y][x]) {
		case '+': cages++; break;
		case 'S': bmons++; break;
		case 'T': tele++; break;
		case 'A': arrival++; break;
		case '@': you++; break;
		case 'M': mons++; break;
		case 'X': exits++; break;
		case '-':
		case ' ': if ((screen[y-1][x] == 'O') && (y > 0)) hanging++;
		    if ((screen[y+1][x] == '^') && (y < NOOFROWS)) hanging++;
		    if ((screen[y][x-1] == '>') && (x > 0)) hanging++;
		    if ((screen[y][x+1] == '<') && (x < ROWLEN)) hanging++;
		    break;
		default : break;
	    }
	    move(y+1,x+1); addch(screen[y][x]);
	}
    move(20,0); addstr("                         ");
    if (cages != bmons) {
	ercount++;
	if (cages < bmons)
	    sprintf(buf,"++++ Warning: %d cage(s), %d baby monster(s).",cages,bmons);
	else
	    sprintf(buf,"**** Cage imbalance: %d cage(s), %d baby monster(s).",cages,bmons);
	if (inform_me(buf,1)) return;
    }
    if (tele > 1) {
	ercount++;
	if (inform_me("++++ Warning: Too many teleports",1)) return;
    }
    if (arrival > ((tele > 0) ? 1 : 0)) {
	ercount++;
	if (tele == 0) {
	    if (inform_me("**** No arrivals without teleports.",1)) return;
	} else if (inform_me("**** Too many arrivals.",1)) return;
    }
    if ((arrival == 0) && (tele > 0)) {
	ercount++;
	if (inform_me("**** No arrival for teleport.",1)) return;
    }
    if (you != 1) {
	ercount++;
        if (you == 0) {
	    if (inform_me("**** No start position.",1)) return;
	} else if (inform_me("**** Too many start positions.",1)) return;
    }
    if (mons > 1) {
	ercount++;
	if (inform_me("**** Too many monsters.",1)) return;
    }
    if (exits != 1) {
	ercount++;
	if (exits == 0) {
	    if (inform_me("**** No exit to screen.",1)) return;
	} else if (inform_me("++++ Warning: Too many exits.",1)) return;
    }
    if (hanging > 0) {
	sprintf(buf,"++++ Warning: %d hanging boulders/arrows/balloons.",hanging);
	if (inform_me(buf,1)) return;
    }
    ercount += hanging;
    move(19,0);
    if (ercount == 0)
	inform_me("---- Screen OK.",0);
    else {
	sprintf(buf,"---- Total errors: %d",ercount);
	inform_me(buf,0);
    }
    refresh();
}

void readstring(str, size)
char *str;
int size;
{
    int count = 0;
    char ch;

    for (;;) {
	ch = getch();
	if (ch == '\n') {
	    *str = '\0';
	    break;
	}
	if ((ch == '\010') || (ch == '\177')) {
	    if (count == 0)
		continue;
	    str--; count--;
	    addstr("\b \b");
	    refresh();
	    continue;
	}
	if (count == size) {
	    printf("\007");
	    continue;
	}
	addch(ch);
	*str = ch;
	str++; count++;
	refresh();
    }
}

void wreadstring(win, str, size)
WINDOW *win;
char *str;
int size;
{
    int count = 0;
    char ch;

    for (;;) {
	ch = wgetch(win);
	if (ch == '\n') {
	    *str = '\0';
	    break;
	}
	if ((ch == '\010') || (ch == '\177')) {
	    if (count == 0)
		continue;
	    str--; count--;
	    waddstr(win,"\b \b");
	    wrefresh(win);
	    continue;
	}
	if (count == size) {
	    printf("\007");
	    continue;
	}
	waddch(win,ch);
	*str = ch;
	str++; count++;
	wrefresh(win);
    }
}


clearbottom()
{
    wmove(messagewin,0,0);
    waddstr(messagewin,"                                                                            \n");
    waddstr(messagewin,"                                                                            \n");
    waddstr(messagewin,"                                                                            ");
}


/* Print instructions around the screen */
void instruct()
{
    int loop;
    wclear(infowin);
    for (loop = 0; inst[loop]; loop++) {
	wmove(infowin,loop,0);
	waddstr(infowin,inst[loop]);
    }
    wrefresh(infowin);
    wmove(messagewin,3,0);
    waddstr(messagewin,"c: change name, m: change moves, q: save and exit, n/p: play game\n");
    waddstr(messagewin,"Press '?' for full editor instructions. Use wanderer keys to move.");
    wrefresh(messagewin);
}

void noins()
{
    clearbottom();
    wclear(infowin);
}

/* save and restore screen data */
screen_save(maxmoves)
int maxmoves;
{
    char file[90];
    char *oldname;
    int y;

    clearbottom(); 
    wmove(messagewin,0,0);
    waddstr(messagewin,"Filename to write to? :");
    if (edit_screen)
	waddstr(messagewin,edit_screen);
    else
	waddstr(messagewin,"./screen");
    wmove(messagewin,0,23);
    wrefresh(messagewin);
    waddstr(messagewin,"                      ");
    wmove(messagewin,0,23);
    wreadstring(messagewin,file,89);
    wmove(messagewin,0,0);
    addstr("                                                                "); 
    wrefresh(messagewin);
    oldname = edit_screen;
    if (file[0]) edit_screen = file;
    for (y = 0; y <= NOOFROWS; y++)	/* make sure screen written */
	if (screen[y][ROWLEN-1] == ' ')	/* correctly... */
	    screen[y][ROWLEN-1] = '-';
    wscreen(0,maxmoves);
    for (y = 0; y <= NOOFROWS; y++)
	if (screen[y][ROWLEN-1] == '-')
	    screen[y][ROWLEN-1] = ' ';
    edit_screen = oldname;
}

screen_read(maxmoves)
int *maxmoves;
{
    static char file[90];
    int y;

    clearbottom();
    wmove(messagewin,0,0);
    waddstr(messagewin,"Filename to read from? :");
    wmove(messagewin,0,24);
    wrefresh(messagewin);
    wreadstring(messagewin,file,89);
    wmove(messagewin,0,0);
    waddstr(messagewin,"                                                   ");
    wrefresh(messagewin);
    if (!file[0]) return;
    edit_screen = file;
    rscreen(0,maxmoves);
    for (y = 0; y <= NOOFROWS; y++)
	if (screen[y][ROWLEN-1] == '-')
    screen[y][ROWLEN-1] = ' ';
}

/* save and restore edit memory data */
edit_save()
{
    char file[90];
    int i = 0, fd;

    clearbottom(); 
    wclear(messagewin);
    wmove(messagewin,0,0);
    waddstr(messagewin,"Solution file to save? :");
    wrefresh(messagewin);
    wreadstring(messagewin,file,89);
    wmove(messagewin,0,0); 
    waddstr(messagewin,"                                                    "); 
    wrefresh(messagewin);
#ifdef TOS
    if ((fd = open(file,O_WRONLY|O_CREAT|O_TRUNC,0644)) < 0)
#else
    if ((fd = open(file,O_WRONLY|O_CREAT|O_TRUNC,0644)) == -1)
#endif
	inform_me("File cannot be opened for writing.",0);
    else {
	i = write(fd, edit_memory, (int)(memory_end - edit_memory));
	if (i < 0) inform_me("Write error on file.",0);
    }
}

edit_restore()
{
    char file[90];
    int i = 0, fd;

    wclear(messagewin);
    wmove(messagewin,0,0);
    waddstr(messagewin,"Solution file to load? :"); 
    wrefresh(messagewin);
    wreadstring(messagewin,file,89);
    wmove(messagewin,0,0);
    waddstr(messagewin,"                                                 ");
    wrefresh(messagewin);
    wmove(messagewin,0,0);
#ifdef TOS
    if ((fd = open(file,O_RDONLY)) < 0)
#else
    if ((fd = open(file,O_RDONLY)) == -1)
#endif
	inform_me("File cannot be opened for reading.",0);
    else {
	i = read(fd, edit_memory, EMSIZE);
	if (i < 0) inform_me("Read error on file.",0);
	if (i == 0) inform_me("File empty.",0);
	if (i > 0) {
	    sprintf(file,"Read in %d moves.",i);
	    inform_me(file,0);
	    memory_end = edit_memory + i;
	}
    }
}

/* Actual edit function */

void editscreen(num, score, bell, maxmoves, keys)
int  num, maxmoves,
     *bell;
long *score;
char keys[10];
{
    int  mmbkup, x, y, sx = 0, sy = 0, quit = 0, nx, ny, nosave = 0;
    char (*frow)[ROWLEN+1] = screen;
    int ch; /* NEW SS 22-12-98 */
    char buffer[50];
    char *howdead;
    char *storage;

    if ((storage = (char *) malloc(sizeof(screen))) == NULL) {
	addstr("Oops... can't malloc a backup screen!\n\n");
	return;
    }

    for (x = 0; x <= ROWLEN; x++)
	for (y = 0; y < NOOFROWS; y++) {
	    if (screen[y][x] == '@') {
		sx = x;
		sy = y;
	    }
	    if (screen[y][x] == '-')
		screen[y][x] = ' ';
	}
    x = sx;
    y = sy;
    if (maxmoves != 0)
	sprintf(buffer,"Moves   : %d        ",maxmoves);
    else
	strcpy(buffer,"Moves   : Unlimited");
    debug_disp = 1;
    win = mapwin;
    wbkgd(win,COLOR_PAIR(1));
    map(frow);
    wmove(messagewin,0,0);
    waddstr(messagewin,buffer);
    wmove(messagewin,1,0);
    waddstr(messagewin,"                                                 ");
    wmove(messagewin,1,0);
    waddstr(messagewin,"Name    : ");
    waddstr(messagewin,screen_name);
    wrefresh(messagewin);

/* ACTUAL EDIT FUNCTION */

    instruct();
    while (!quit) {
	wmove(win,y+1,x+1);
	wrefresh(win);
	ch = wgetch(win);

	nx = x;
	ny = y;

	if (ch == keys[3] || ch == keys[2] || ch == keys[1] || ch == keys[0])
        {
	    if (ch == keys[3]) nx++;
	    if (ch == keys[2]) nx--;
	    if (ch == keys[1]) ny++;
	    if (ch == keys[0]) ny--;
	}
        else if (ch == KEY_RIGHT || ch == KEY_LEFT
              || ch == KEY_UP || ch == KEY_DOWN)
        {
            if (ch == KEY_RIGHT) nx++;
            if (ch == KEY_LEFT)  nx--;
            if (ch == KEY_DOWN)  ny++;
            if (ch == KEY_UP)    ny--;
        }
	else if (ch == 'q') {
	    clearbottom();
	    wmove(messagewin,0,0);
	    waddstr(messagewin,"Do you want to save the sreen?");
	    wrefresh(messagewin);
	    ch = wgetch(messagewin);
	    if(ch == 'n')
	      nosave=1;
	    break;
	} else if (ch == 'x') {
	    clearbottom();
	    wmove(messagewin,0,0);
	    waddstr(messagewin,"You will lose any changes made\n this session - are you sure? (y/n)");
	    wrefresh(messagewin);
	    ch = wgetch(messagewin);
	    if (ch != 'y') {
		noins();
		instruct();
		wrefresh(messagewin);
	    } else {
		nosave = 1;
		waddstr(messagewin,"\n");
		wrefresh(messagewin);
		break;
	    }
	} else if (ch == 'm') {	/* change to number of moves for the screen */
	    clearbottom();
	    wmove(messagewin,0,0);
	    waddstr(messagewin,"How many moves for this screen? :");
	    wrefresh(messagewin); echo();
	    scanf("%d",&maxmoves);noecho();
	    if (maxmoves < 0) maxmoves = 0;
	    if (maxmoves != 0)
		sprintf(buffer,"Moves   : %d        ",maxmoves);
	    else
		strcpy(buffer,"Moves   : Unlimited ");
	    instruct();
	    waddstr(messagewin,buffer);
	    wrefresh(messagewin);/* for some reason, this seems to add a '.'
			        /* to the map... I've no idea why yet... */
	} else if (ch == 'c') {	/* change name */
	    clearbottom();
	    wmove(messagewin,0,0);
	    waddstr(messagewin,"New name: ");
	    wrefresh(messagewin);
	    wreadstring(messagewin,screen_name,60);
	    instruct();
	    wmove(messagewin,0,0);
	    waddstr(messagewin,"                                       ");
	    wmove(messagewin,0,0);
	    waddstr(messagewin,"Name  : ");
	    waddstr(messagewin,screen_name);
	    wrefresh(messagewin);
	} else if (ch == 'p' || ch == 'n') {	/* play the game (test) */
	    noins();
	    mmbkup = maxmoves;
	    bcopy(screen,storage,sizeof(screen));
	    if (ch == 'p') {
		debug_disp = 0;
		wclear(win);
	    }
	    *score = 0;
            wbkgd(win,COLOR_PAIR(2));
	    howdead = playscreen(&num,score,bell,maxmoves,keys);
	    wmove(messagewin,0,0);
	    if (howdead != 0)
		waddstr(messagewin,howdead);
	    else
		waddstr(messagewin,"DONE!");
	    wprintw(messagewin,"; hit any key to continue\n");
	    wrefresh(messagewin);
	    ch = wgetch(messagewin);
	    wclear(mapwin);
	    bcopy(storage,screen,sizeof(screen));
	    maxmoves = mmbkup;
	    debug_disp = 1;
            wbkgd(win,COLOR_PAIR(1)); 
	    map(frow);
	    if (maxmoves != 0)
		sprintf(buffer,"Moves   : %d        \n",maxmoves);
	    else
		strcpy(buffer,"Moves   : Unlimited\n");
	    wmove(messagewin,0,0);
	    waddstr(messagewin,buffer);
	    waddstr(messagewin,"Name    : ");
	    waddstr(messagewin,screen_name);
            wrefresh(messagewin);
	    instruct();
	} else if (ch == 18) {	/* ctrl r -- read memory data */
	    {edit_restore(); instruct();}
	} else if (ch == 23) {	/* ctrl w -- write memory data */
	    {edit_save(); instruct();}
	} else if (ch == 7) {	/* ctrl g -- read screen */
	    screen_read(&maxmoves);
	    map(frow);
	    instruct();
	} else if (ch == 16) {	/* ctrl p -- write screen */
	    screen_save(maxmoves);
	    instruct();
	} else if (ch == 12) {	/* ctrl l -- redraw screen  */
	    clear();
	    map(frow);
	    if (maxmoves != 0)
		sprintf(buffer,"Moves   : %d        \n",maxmoves);
	    else
		strcpy(buffer,"Moves   : Unlimited\n");
	    move(18,0);
	    addstr(buffer);
	    addstr("Name    : ");
	    addstr(screen_name);
	    instruct();
	} else if (ch == 'L') {
	    clearbottom();
	    check_legality();
	    instruct();
	} else if (ch == '?') {
	    helpme(0);
	    if (maxmoves != 0)
		sprintf(buffer,"Moves   : %d        \n",maxmoves);
	    else
		strcpy(buffer,"Moves   : Unlimited\n");
	    map(frow);
	} else if ((ch == 127) || (ch == 8)) {  /* delete key */
	    if (--nx < 0) {
		nx = ROWLEN -1;
		if (--ny < 0) ny = NOOFROWS -1;
	    }
	    screen[ny][nx] = ' ';
	    move(ny+1,nx+1);
	    addch(' ');
	} else {
	    if (ch >= 'a' && ch <= 'z') ch = ch - 'a' + 'A';
	    if (ch == '"') ch = getchar();
	    if (!(ch < ' ')) {
		screen[y][x] = ch;
		wmove(win,y+1,x+1);
		waddch(win,ch);
		nx++;
	    }
	}
	if (nx < 0) {
	    nx = ROWLEN-1;
	    ny--;
	}
	if (nx >= ROWLEN) {
	    nx = 0;
	    ny++;
	}
	if (ny < 0) ny = NOOFROWS-1;
	if (ny >= NOOFROWS) ny = 0;
	move(ny+1,nx+1);
	x = nx;
	y = ny;
    }

    noins();
    move(20,0);
    refresh();

    if (!nosave) {
	for (y = 0; y <= NOOFROWS; y++) /* certain editors - eg ded - have a */
				/* habit of truncating trailing spaces */
				/* so this should stop them! */
	    if (screen[y][ROWLEN-1] == ' ')
		screen[y][ROWLEN-1] = '-';
	wscreen(num,maxmoves);
    }
}
