; ==============================================================================
; Modul: DISGBTAB.ASM
; ==============================================================================
; In diesem Modul sind die ntigen Tabellen fr einen GB Disassembler.
; ==============================================================================

IDEAL

GLOBAL OpCodeTab:NEAR
GLOBAL OpNames:NEAR
GLOBAL RegNames:NEAR
GLOBAL TokenEnd:NEAR

SEGMENT Code PARA PUBLIC 'CODE'

LABEL OpCodeTab NEAR

; Kein Prefix:

DW OFFSET Tab0
DW OFFSET Tab1
DW OFFSET Tab2
DW OFFSET Tab3

; Prefix $CB

DW OFFSET TabCB0
DW OFFSET TabCB1
DW OFFSET TabCB2
DW OFFSET TabCB3

nix DB 0

; Opcode-Namen:

MACRO MakeName N
na_&N DB "&N",0
ENDM

LABEL OpNames NEAR

MakeName adc
MakeName add
MakeName and
MakeName bit
MakeName call
MakeName ccf
MakeName cp
MakeName cpl
MakeName daa
MakeName dec
MakeName djnz
MakeName di
MakeName ei
MakeName halt
MakeName im
MakeName inc
MakeName jp
MakeName jr
MakeName ld
MakeName neg
MakeName nop
MakeName or
MakeName pop
MakeName push
MakeName res
MakeName ret
MakeName reti
MakeName retn
MakeName rl
MakeName rla
MakeName rlc
MakeName rlca
MakeName rld
MakeName rr
MakeName rra
MakeName rrc
MakeName rrca
MakeName rrd
MakeName rst
MakeName sbc
MakeName scf
MakeName set
MakeName sla
MakeName swap
MakeName sra
MakeName srl
MakeName sub
MakeName xor

; illegale Opcodes des GB:
MakeName Movsp
MakeName Movsn

LABEL RegNames NEAR

; Registernamen:

MakeName b
MakeName c
MakeName d
MakeName e
MakeName h
MakeName l
MakeName a
MakeName bc
MakeName de
MakeName hl
MakeName sp
MakeName af

na_pc  DB "(C)",0
na_bcp DB "(BC)",0
na_dep DB "(DE)",0
na_hlp DB "(HL)",0
na_spp DB "(SP)",0

; FlagNamen

na_fNZ DB "NZ",0
na_fZ  DB "Z",0
na_fNC DB "NC",0
na_fC  DB "C",0
na_fNS DB "NS",0
na_fS  DB "S",0

LABEL TokenEnd NEAR

; Der Rest ...

na_error DB "???",0

; Verteilungsmodi:
dir_opc		EQU 1
tab_opc		EQU 2
dir_par		EQU 3
tab_par		EQU 4
abs_par         EQU 5
rst_par		EQU 6
bts_par         EQU 7

t_tree		EQU 0
t_end		EQU 1

par_1		EQU 0
par_2		EQU 1
bit_4		EQU 2

; Eine genauere Beschreibung des Parameters/OpCodes:
Bit_8		EQU 0
Bit_16		EQU 1
Pointer		EQU 2
Relative	EQU 4
Absolute	EQU 8
Conditional	EQU 16
_Jump		EQU 32
_Call		EQU 64
IO_Tab		EQU 128
X_Tab		EQU 256

; Opcode-Tabellen:

LABEL Tab0 WORD
DW t_tree,par_2
DW OFFSET Group_1_0
DW OFFSET Group_1_1
DW OFFSET Group_1_2
DW OFFSET Group_1_3
DW OFFSET Group_1_4
DW OFFSET Group_1_5
DW OFFSET Group_1_6
DW OFFSET Group_1_7
DW 0

LABEL Tab1 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW tab_par,par_1,Tab_r
DW tab_par,par_2,Tab_r
DW 0

LABEL Tab2 WORD
DW t_end
DW tab_opc,par_1,OFFSET Math_Tab
DW dir_par,OFFSET na_a
DW tab_par,par_2,OFFSET Tab_r
DW 0

LABEL Tab3 WORD
DW t_tree,par_2
DW OFFSET Group_3_0
DW OFFSET Group_3_1
DW OFFSET Group_3_2
DW OFFSET Group_3_3
DW OFFSET Group_3_4
DW OFFSET Group_3_5
DW OFFSET Group_3_6
DW OFFSET Group_3_7
DW 0

LABEL TabCB0 WORD
DW t_end
DW tab_opc,par_1,OFFSET Shift_Tab
DW tab_par,par_2,OFFSET tab_r
DW 0

LABEL TabCB1 WORD
DW t_end
DW dir_opc,OFFSET na_Bit
DW bts_par,par_1
DW tab_par,par_2,tab_r
DW 0

LABEL TabCB2 WORD
DW t_end
DW dir_opc,OFFSET na_res
DW bts_par,par_1
DW tab_par,par_2,tab_r
DW 0

LABEL TabCB3 WORD
DW t_end
DW dir_opc,OFFSET na_set
DW bts_par,par_1
DW tab_par,par_2,tab_r
DW 0

LABEL Unb WORD
DW t_end
DW dir_opc,OFFSET na_error
DW 0

LABEL Group_1_0 WORD
DW t_tree,Par_1
DW OFFSET Group_1_0_0
DW OFFSET Group_1_0_1
DW OFFSET Group_1_0_2
DW OFFSET Group_1_0_3
DW OFFSET Group_1_0_4
DW OFFSET Group_1_0_5
DW OFFSET Group_1_0_6
DW OFFSET Group_1_0_7
DW 0

LABEL Group_1_0_0 WORD
DW t_end
DW dir_opc,OFFSET na_NOP
DW 0

LABEL Group_1_0_1 WORD
DW t_end
DW dir_opc,OFFSET na_error
DW abs_par,Bit_16
DW 0

LABEL Group_1_0_2 WORD
DW t_end
DW dir_opc,OFFSET na_djnz
DW abs_par,Bit_8+_Jump+Relative
DW 0

LABEL Group_1_0_3 WORD
DW t_end
DW dir_opc,OFFSET na_Jr
DW abs_par,Bit_8+_Jump+Relative
DW 0

LABEL Group_1_0_4 WORD
DW t_end
DW dir_opc,OFFSET na_Jr
DW dir_par,OFFSET na_fNZ
DW abs_par,Bit_8+_Jump+Relative
DW 0

LABEL Group_1_0_5 WORD
DW t_end
DW dir_opc,OFFSET na_Jr
DW dir_par,OFFSET na_fZ
DW abs_par,Bit_8+_Jump+Relative
DW 0

LABEL Group_1_0_6 WORD
DW t_end
DW dir_opc,OFFSET na_Jr
DW dir_par,OFFSET na_fNC
DW abs_par,Bit_8+_Jump+Relative
DW 0

LABEL Group_1_0_7 WORD
DW t_end
DW dir_opc,OFFSET na_Jr
DW dir_par,OFFSET na_fC
DW abs_par,Bit_8+_Jump+Relative
DW 0

LABEL Group_1_1 WORD
DW t_tree,Bit_4
DW OFFSET Group_1_1_A
DW OFFSET Group_1_1_B
DW 0

LABEL Group_1_1_A WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW tab_par,par_1,OFFSET tab_dd
DW abs_par,Bit_16
DW 0

LABEL Group_1_1_B WORD
DW t_end
DW dir_opc,OFFSET na_add
DW dir_par,OFFSET na_HL
DW tab_par,par_1,OFFSET Tab_ss
DW 0

LABEL Group_1_2 WORD
DW t_tree,par_1
DW OFFSET Group_1_2_0
DW OFFSET Group_1_2_1
DW OFFSET Group_1_2_2
DW OFFSET Group_1_2_3
DW OFFSET Group_1_2_4
DW OFFSET Group_1_2_5
DW OFFSET Group_1_2_6
DW OFFSET Group_1_2_7
DW 0

LABEL Group_1_2_0 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_par,OFFSET na_BCP
DW dir_par,OFFSET na_a
DW 0

LABEL Group_1_2_1 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_par,OFFSET na_a
DW dir_par,OFFSET na_BCP
DW 0

LABEL Group_1_2_2 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_par,OFFSET na_DEP
DW dir_par,OFFSET na_a
DW 0

LABEL Group_1_2_3 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_par,OFFSET na_a
DW dir_par,OFFSET na_DEP
DW 0

; Unbekannt
; LABEL Group_1_2_4 WORD
; DW t_end
; DW dir_opc,OFFSET na_ld
; DW abs_par,Bit_16+Pointer
; DW dir_par,OFFSET na_hl
; DW 0

; LABEL Group_1_2_5 WORD
; DW t_end
; DW dir_opc,OFFSET na_ld
; DW dir_par,OFFSET na_hl
; DW abs_par,Bit_16+Pointer
; DW 0

; LABEL Group_1_2_6 WORD
; DW t_end
; DW dir_opc,OFFSET na_ld
; DW abs_par,Bit_16+Pointer
; DW dir_par,OFFSET na_a
; DW 0

; LABEL Group_1_2_7 WORD
; DW t_end
; DW dir_opc,OFFSET na_ld
; DW dir_par,OFFSET na_a
; DW abs_par,Bit_16+Pointer
; DW 0

; String Befehl:
; a -> (HL)
; HL++
LABEL Group_1_2_4 WORD
DW t_end
DW dir_opc,OFFSET na_Movsp
DW dir_par,OFFSET na_hlp
DW dir_par,OFFSET na_a
DW 0

; String Befehl:
; a <- (HL)
; HL++
LABEL Group_1_2_5 WORD
DW t_end
DW dir_opc,OFFSET na_Movsp
DW dir_par,OFFSET na_a
DW dir_par,OFFSET na_hlp
DW 0

; String Befehl:
; a -> (HL)
; HL--
LABEL Group_1_2_6 WORD
DW t_end
DW dir_opc,OFFSET na_Movsn
DW dir_par,OFFSET na_hlp
DW dir_par,OFFSET na_a
DW 0

; String Befehl:
; a <- (HL)
; HL--
LABEL Group_1_2_7 WORD
DW t_end
DW dir_opc,OFFSET na_Movsn
DW dir_par,OFFSET na_a
DW dir_par,OFFSET na_hlp
DW 0

LABEL Group_1_3 WORD
DW t_tree,Bit_4
DW Group_1_3_A
DW Group_1_3_B
DW 0

LABEL Group_1_3_A WORD
DW t_end
DW dir_opc,OFFSET na_inc
DW tab_par,par_1,OFFSET tab_ss
DW 0

LABEL Group_1_3_B WORD
DW t_end
DW dir_opc,OFFSET na_dec
DW tab_par,par_1,OFFSET tab_ss
DW 0

LABEL Group_1_4 WORD
DW t_end
DW dir_opc,OFFSET na_inc
DW tab_par,par_1,OFFSET tab_r
DW 0

LABEL Group_1_5 WORD
DW t_end
DW dir_opc,OFFSET na_dec
DW tab_par,par_1,OFFSET tab_r
DW 0

LABEL Group_1_6 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW tab_par,Par_1,OFFSET Tab_r
DW abs_par,Bit_8
DW 0

LABEL Group_1_7 WORD
DW t_tree,par_1
DW OFFSET Group_1_7_0
DW OFFSET Group_1_7_1
DW OFFSET Group_1_7_2
DW OFFSET Group_1_7_3
DW OFFSET Group_1_7_4
DW OFFSET Group_1_7_5
DW OFFSET Group_1_7_6
DW OFFSET Group_1_7_7
DW 0

LABEL Group_1_7_0 WORD
DW t_end
DW dir_opc,OFFSET na_rlca
DW 0

LABEL Group_1_7_1 WORD
DW t_end
DW dir_opc,OFFSET na_rrca
DW 0

LABEL Group_1_7_2 WORD
DW t_end
DW dir_opc,OFFSET na_rla
DW 0

LABEL Group_1_7_3 WORD
DW t_end
DW dir_opc,OFFSET na_rra
DW 0

LABEL Group_1_7_4 WORD
DW t_end
DW dir_opc,OFFSET na_daa
DW 0

LABEL Group_1_7_5 WORD
DW t_end
DW dir_opc,OFFSET na_cpl
DW 0

LABEL Group_1_7_6 WORD
DW t_end
DW dir_opc,OFFSET na_scf
DW 0

LABEL Group_1_7_7 WORD
DW t_end
DW dir_opc,OFFSET na_ccf
DW 0

; Dieser Befehl ist im Gameboy "anders" implementiert.
; LABEL Group_3_0 WORD
; DW t_end
; DW dir_opc,OFFSET na_ret
; DW tab_par,par_1,OFFSET tab_cc
; DW 0

LABEL Group_3_0 WORD
DW t_tree,par_1
DW OFFSET Group_3_0_0
DW OFFSET Group_3_0_1
DW OFFSET Group_3_0_2
DW OFFSET Group_3_0_3
DW OFFSET Group_3_0_4
DW OFFSET Group_3_0_5
DW OFFSET Group_3_0_6
DW OFFSET Group_3_0_7
DW 0

LABEL Group_3_0_0 WORD
DW t_end
DW dir_opc,OFFSET na_ret
DW tab_par,par_1,OFFSET tab_cc
DW 0

LABEL Group_3_0_1 WORD
DW t_end
DW dir_opc,OFFSET na_ret
DW tab_par,par_1,OFFSET tab_cc
DW 0

LABEL Group_3_0_2 WORD
DW t_end
DW dir_opc,OFFSET na_ret
DW tab_par,par_1,OFFSET tab_cc
DW 0

LABEL Group_3_0_3 WORD
DW t_end
DW dir_opc,OFFSET na_ret
DW tab_par,par_1,OFFSET tab_cc
DW 0

LABEL Group_3_0_4 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW abs_par,Bit_8+IO_TAB+Pointer
DW dir_par,na_a
DW 0

LABEL Group_3_0_5 WORD  ; Push nn ?
DW t_end
DW dir_opc,OFFSET na_add
DW dir_par,na_sp
DW abs_par,Bit_8
DW 0

LABEL Group_3_0_6 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_par,na_a
DW abs_par,Bit_8+IO_Tab+Pointer
DW 0

LABEL Group_3_0_7 WORD
DW t_end
DW dir_opc,OFFSET na_error
DW abs_par,Bit_8
DW 0

LABEL Group_3_1 WORD
DW t_tree,Bit_4
DW Group_3_1_A
DW Group_3_1_B
DW 0

LABEL Group_3_1_A WORD
DW t_end
DW dir_opc,OFFSET na_Pop
DW tab_par,Par_1,OFFSET tab_qq
DW 0

LABEL Group_3_1_B WORD
DW t_tree,Par_1
DW Group_3_1_B_0
DW Group_3_1_B_1
DW Group_3_1_B_2
DW Group_3_1_B_3
DW 0

LABEL Group_3_1_B_0 WORD
DW t_end
DW dir_opc,OFFSET na_Ret
DW 0

; Normalerweise exx
LABEL Group_3_1_B_1 WORD
DW t_end
DW dir_opc,OFFSET na_reti
DW 0

LABEL Group_3_1_B_2 WORD
DW t_end
DW dir_opc,OFFSET na_Jp
DW dir_par,OFFSET na_HLP
DW 0

LABEL Group_3_1_B_3 WORD
DW t_end
DW dir_opc,OFFSET na_LD
DW dir_par,OFFSET na_SP
DW dir_par,OFFSET na_HL
DW 0

LABEL Group_3_2 WORD
DW t_tree,par_1
DW OFFSET Group_3_2_0
DW OFFSET Group_3_2_1
DW OFFSET Group_3_2_2
DW OFFSET Group_3_2_3
DW OFFSET Group_3_2_4
DW OFFSET Group_3_2_5
DW OFFSET Group_3_2_6
DW OFFSET Group_3_2_7
DW 0

LABEL Group_3_2_0 WORD
DW t_end
DW dir_opc,OFFSET na_Jp
DW tab_par,par_1,OFFSET tab_cc
DW abs_par,Bit_16+_Jump+Absolute
DW 0

LABEL Group_3_2_1 WORD
DW t_end
DW dir_opc,OFFSET na_Jp
DW tab_par,par_1,OFFSET tab_cc
DW abs_par,Bit_16+_Jump+Absolute
DW 0

LABEL Group_3_2_2 WORD
DW t_end
DW dir_opc,OFFSET na_Jp
DW tab_par,par_1,OFFSET tab_cc
DW abs_par,Bit_16+_Jump+Absolute
DW 0

LABEL Group_3_2_3 WORD
DW t_end
DW dir_opc,OFFSET na_Jp
DW tab_par,par_1,OFFSET tab_cc
DW abs_par,Bit_16+_Jump+Absolute
DW 0

LABEL Group_3_2_4 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_opc,OFFSET na_pc
DW dir_opc,OFFSET na_a
DW 0

LABEL Group_3_2_5 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW abs_par,Bit_16+Pointer
DW dir_par,OFFSET na_a
DW 0

LABEL Group_3_2_6 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_opc,OFFSET na_a
DW dir_opc,OFFSET na_pc
DW 0

LABEL Group_3_2_7 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_par,OFFSET na_a
DW abs_par,Bit_16+Pointer
DW 0

LABEL Group_3_3 WORD
DW t_tree,par_1
DW Group_3_3_0
DW unb
DW Group_3_3_2
DW Group_3_3_3
DW Group_3_3_4
DW Group_3_3_5
DW Group_3_3_6
DW Group_3_3_7
DW 0

LABEL Group_3_3_0 WORD
DW t_end
DW dir_opc,OFFSET na_Jp
DW abs_par,Bit_16+_Jump+Absolute
DW 0

LABEL Group_3_3_2 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW abs_par,Bit_8+IO_Tab
DW dir_par,OFFSET na_a
DW 0

LABEL Group_3_3_3 WORD
DW t_end
DW dir_opc,OFFSET na_ld
DW dir_par,OFFSET na_a
DW abs_par,Bit_8+IO_Tab
DW 0

LABEL Group_3_3_4 WORD
DW t_end
DW dir_opc,OFFSET na_error
DW 0

LABEL Group_3_3_5 WORD
DW t_end
DW dir_opc,OFFSET na_error
DW 0

LABEL Group_3_3_6 WORD
DW t_end
DW dir_opc,OFFSET na_di
DW 0

LABEL Group_3_3_7 WORD
DW t_end
DW dir_opc,OFFSET na_ei
DW 0

; Dieser Befehl ist auf dem GB nicht vollstndig benutzt
; LABEL Group_3_4 WORD
; DW t_end
; DW dir_opc,OFFSET na_call
; DW tab_par,par_1,OFFSET tab_cc
; DW abs_par,Bit_16+_Call+Absolute
; DW 0

LABEL Group_3_4 WORD
DW t_tree,Par_1
DW OFFSET Group_3_4_0
DW OFFSET Group_3_4_1
DW OFFSET Group_3_4_2
DW OFFSET Group_3_4_3
DW OFFSET Group_3_4_4
DW OFFSET Group_3_4_5
DW OFFSET Group_3_4_6
DW OFFSET Group_3_4_7
DW 0

LABEL Group_3_4_0 WORD
DW t_end
DW dir_opc,OFFSET na_call
DW tab_par,par_1,OFFSET tab_cc
DW abs_par,Bit_16+_Call+Absolute
DW 0

LABEL Group_3_4_1 WORD
DW t_end
DW dir_opc,OFFSET na_call
DW tab_par,par_1,OFFSET tab_cc
DW abs_par,Bit_16+_Call+Absolute
DW 0

LABEL Group_3_4_2 WORD
DW t_end
DW dir_opc,OFFSET na_call
DW tab_par,par_1,OFFSET tab_cc
DW abs_par,Bit_16+_Call+Absolute
DW 0

LABEL Group_3_4_3 WORD
DW t_end
DW dir_opc,OFFSET na_call
DW tab_par,par_1,OFFSET tab_cc
DW abs_par,Bit_16+_Call+Absolute
DW 0

LABEL Group_3_4_4 WORD
DW t_end
DW dir_opc,OFFSET na_error
DW 0

LABEL Group_3_4_5 WORD
DW t_end
DW dir_opc,OFFSET na_error
DW 0

LABEL Group_3_4_6 WORD
DW t_end
DW dir_opc,OFFSET na_error
DW abs_par,Bit_8
DW 0

LABEL Group_3_4_7 WORD
DW t_end
DW dir_opc,OFFSET na_error
DW abs_par,Bit_8
DW 0

LABEL Group_3_5 WORD
DW t_tree,Bit_4
DW Group_3_5_A
DW Group_3_5_B
DW 0

LABEL Group_3_5_A WORD
DW t_end
DW dir_opc,OFFSET na_Push
DW tab_par,Par_1,OFFSET Tab_qq
DW 0

LABEL Group_3_5_B WORD
DW t_tree,Par_1
DW OFFSET Group_3_5_B_0
DW OFFSET Unb
DW OFFSET Unb
DW OFFSET Unb
DW 0

LABEL Group_3_5_B_0 WORD
DW t_end
DW dir_opc,OFFSET na_call
DW abs_par,Bit_16+_Call+Absolute
DW 0

LABEL Group_3_6 WORD
DW t_end
DW tab_opc,par_1,OFFSET Math_Tab
DW dir_par,OFFSET na_a
DW abs_par,Bit_8
DW 0

LABEL Group_3_7 WORD
DW t_end
DW dir_opc,OFFSET na_rst
DW rst_par
DW 0

LABEL Math_Tab WORD
DW OFFSET na_add
DW OFFSET na_adc
DW OFFSET na_sub
DW OFFSET na_sbc
DW OFFSET na_and
DW OFFSET na_xor
DW OFFSET na_or
DW OFFSET na_cp

LABEL Shift_Tab WORD
DW OFFSET na_rlc
DW OFFSET na_rrc
DW OFFSET na_rl
DW OFFSET na_rr
DW OFFSET na_sla
DW OFFSET na_sra
DW OFFSET na_swap
DW OFFSET na_srl

LABEL Tab_r WORD
DW OFFSET na_b
DW OFFSET na_c
DW OFFSET na_d
DW OFFSET na_e
DW OFFSET na_h
DW OFFSET na_l
DW OFFSET na_hlp
DW OFFSET na_a

LABEL Tab_cc WORD
DW OFFSET na_fNZ
DW OFFSET na_fZ
DW OFFSET na_fNC
DW OFFSET na_fC
DW 0
DW 0
DW OFFSET na_fNS
DW OFFSET na_fS

LABEL Tab_qq WORD
DW OFFSET na_BC
DW OFFSET na_DE
DW OFFSET na_HL
DW OFFSET na_AF

LABEL Tab_dd WORD
LABEL Tab_ss WORD
DW OFFSET na_BC
DW OFFSET na_DE
DW OFFSET na_HL
DW OFFSET na_SP

ENDS

END
