; =============================================================================
;  General definitions for GB-Games
; =============================================================================
;  This file can be used for GBSIM, my GB-Disassembler and a GB-Assembler.
;  You may use a standard Z80-Assembler.
;  Everything marked with ?? is just a guess.
; =============================================================================

; == Vectors: ==

VEC_Int_1               EQU 00040h ; IRQ: VBI
VEC_Int_2               EQU 00048h ; IRQ: FLI
VEC_Int_3               EQU 00050h ; IRQ: TIMER
VEC_Int_4               EQU 00058h ; IRQ: SERIAL DONE
VEC_Int_5               EQU 00060h ; IRQ: JOYPAD
VEC_Powerup             EQU 00100h
VEC_End_of_Header       EQU 00150h

; == Labels: ==

INF_Logo        EQU 00104h
INF_Name        EQU 00134h
INF_Config      EQU 00147h 
INF_ROMSize     EQU 00148h
INF_SRAMSize    EQU 00149h
INF_Producer    EQU 0014Bh

VMEM_Screen_1   EQU 09800h
VMEM_Screen_2   EQU 09C00h
VMEM_Font_1     EQU 08000h
VMEM_Font_2     EQU 08800h
VMEM_Font_3     EQU 09000h

; == Hardware: ==

MMU_ROM         EQU 02100h ; anything like 02xxxh does it...

SYS_JOYPAD      EQU 0FF00h

SIO_DATA        EQU 0FF01h
SIO_CTRL        EQU 0FF02h

SYS_RND         EQU 0FF04h

TIMER_COUNT     EQU 0FF05h
TIMER_MOD       EQU 0FF06h
TIME_CTRL       EQU 0FF07h

IRQ_FLAGS       EQU 0FF0Fh
IRQ_MASK        EQU 0FFFFh

SND1_SWEEP      EQU 0FF10h
SND1_WAVE       EQU 0FF11h
SND1_ENVELOPE   EQU 0FF12h
SND1_FREQLO     EQU 0FF13h
SND1_FREQHI     EQU 0FF14h
SND2_WAVE       EQU 0FF15h
SND2_ENVELOPE   EQU 0FF16h
SND2_FREQLO     EQU 0FF17h
SND2_FREQHI     EQU 0FF18h
SND3_ENABLE     EQU 0FF1Ah
SND3_LENGTH     EQU 0FF1Bh
SND3_LEVEL      EQU 0FF1Ch
SND3_FREQLO     EQU 0FF1Dh
SND3_FREQHI     EQU 0FF1Eh
SND4_LENGTH     EQU 0FF20h
SND4_ENVELOPE   EQU 0FF21h
SND4_COUNTER    EQU 0FF22h
SND4_INIT       EQU 0FF23h
SND_CONTROL     EQU 0FF24h
SND_OUTPUT      EQU 0FF25h
SND_ENABLE      EQU 0FF26h
SND_WAVEPATTERN EQU 0FF30h

; Thanks to Peter Knight and his BASIC-disassembler for this names:
VID_LCDC        EQU 0FF40h ; Display control
VID_STAT        EQU 0FF41h ; Display status
VID_SCY         EQU 0FF42h ; Panning V
VID_SCX         EQU 0FF43h ; Panning H
VID_LY          EQU 0FF44h ; Scanline
VID_LYC         EQU 0FF45h ; FLI - scanline
VID_SPRDMA      EQU 0FF46h ; Starts sprite-DMA from xx00
VID_BGP         EQU 0FF47h ; Background palette
VID_SP0         EQU 0FF48h ; Sprite palette 1
VID_SP1         EQU 0FF49h ; Sprite palette 2
VID_WY          EQU 0FF4Ah ; Screen 2 V-pos
VID_WX          EQU 0FF4Bh ; Screen 2 H-pos

;HEADER 0100
