PROGRAM GDump; { Grafische Darstellung der Moduldaten }

USES
  Crt;

TYPE
  PBuffer = ^TBuffer;
  TBuffer = ARRAY [0..65534] OF Byte;

VAR
  Data         : File;
  Screen       : ARRAY [0..199,0..39] OF Byte ABSOLUTE $A000:0000;

  Buffer       : PBuffer;
  BufSize      : Word;

  C            : Byte;
  Ch           : Char;

  ScrPos       : Word;
  FontPos      : Word;

  Monomode     : Boolean;

  FP           : Word;

  SaveName     : String;

PROCEDURE ShowChar(X,Y,C : Byte);
VAR
  XX,YY,Col : Word;
  C1,C2 : Byte;
  AF    : Word;
BEGIN
  Port[$3C4]:=2;
  Port[$3C5]:=$F;
  FOR YY:=0 TO 7 DO
    Screen[Y*8+YY,X]:=0;
    IF Monomode THEN BEGIN
      Port[$3C4]:=2;
      Port[$3C5]:=3;
      FOR YY:=0 TO 7 DO
        Screen[Y*8+YY,X]:=Buffer^[FontPos+C*8+YY];
    END ELSE BEGIN
      FOR YY:=0 TO 7 DO
        FOR Col:=0 TO 1 DO BEGIN
	  Port[$3C4]:=2;
	  Port[$3C5]:=1 SHL Col;
	  Screen[Y*8+YY,X]:=Buffer^[FontPos+C*16+YY*2+Col];
        END;
    END;
END;

PROCEDURE ShowScreen;
VAR
  XC,YC : Word;
BEGIN
  FOR YC:=0 TO 17 DO
    FOR XC:=0 TO 19 DO
      ShowChar(XC,YC,Buffer^[ScrPos+YC*32+XC]);
END;

PROCEDURE ShowFont;
VAR
  C : Word;
BEGIN
  FOR C:=0 TO 255 DO
    ShowChar(21+(C MOD 16),C DIV 16,C);
END;

BEGIN
  WriteLn('GBGraph V2.0');
  IF ParamCount<>1 THEN BEGIN
    WriteLn('Syntax: GBGRAPH <File>');
  END ELSE BEGIN
    New(Buffer);
    DirectVideo:=False;
    FP:=0;
    Assign(Data,ParamStr(1));
    Reset(Data,1);
    Blockread(Data,Buffer^,SizeOf(TBuffer),BufSize);
    ASM
      Mov AX,$0D
      INT $10
    END;
    FOR C:=0 TO 3 DO BEGIN
      Port[$3C8]:=3-C;
      Port[$3C9]:=27+12*C;
      Port[$3C9]:=27+12*C;
      Port[$3C9]:=27+12*C;
    END;
    FOR C:=0 TO 15 DO BEGIN
      Port[$3C0]:=C;
      Port[$3C0]:=C;
    END;
    Port[$3C0]:=$20;
    ScrPos:=0;
    FontPos:=0;
    Monomode:=False;
    REPEAT
      ShowScreen;
      ShowFont;
      ShowChar(10,20,$85);
      Ch:=UpCase(ReadKey);
      CASE Ch OF
        'Y' : IF FP>0 THEN BEGIN
                Dec(FP);
                Seek(Data,LongInt(LongInt(FP)*LongInt(SizeOf(TBuffer))));
                Blockread(Data,Buffer^,SizeOf(TBuffer),BufSize);
              END;
        'X' : IF FP<(FileSize(Data) DIV SizeOf(TBuffer)) THEN BEGIN
                Inc(FP);
                Seek(Data,LongInt(LongInt(FP)*LongInt(SizeOf(TBuffer))));
                Blockread(Data,Buffer^,SizeOf(TBuffer),BufSize);
              END;
        '+' : IF NOT Monomode THEN Inc(FontPos,2) ELSE Inc(FontPos);
        '-' : IF NOT Monomode THEN Dec(FontPos,2) ELSE Dec(FontPos);
        '1' : IF NOT Monomode THEN Inc(FontPos,16) ELSE Inc(FontPos,8);
        '2' : IF NOT Monomode THEN Dec(FontPos,16) ELSE Dec(FontPos,8);
	'3' : Inc(FontPos,128);
        '4' : Dec(FontPos,128);
        '5' : Inc(FontPos,4096);
        '6' : Dec(FontPos,4096);
        'S' : FontPos:=FontPos XOR 1;
        'M' : Monomode:=NOT Monomode;
        #0 : CASE ReadKey OF
               'M':IF ScrPos<BufSize THEN Inc(ScrPos);
               'K':IF ScrPos>0 THEN Dec(ScrPos);
	       'P':IF ScrPos<(BufSize-32) THEN Inc(ScrPos,32);
	       'H':IF ScrPos>=32 THEN Dec(ScrPos,32);
               'I':IF ScrPos>359 THEN Dec(ScrPos,360);
               'Q':IF ScrPos<(BufSize-360) THEN Inc(ScrPos,360);
             END;
      END;
    UNTIL (Ch=#27) OR (Ch='W');
    Close(Data);
    ASM
      Mov AX,$3
      INT $10
    END;
    IF Ch='W' THEN BEGIN
      Write('Dateiname:');
      ReadLn(SaveName);
      Assign(Data,SaveName);
      ReWrite(Data,1);
      IF Monomode THEN  BEGIN
        BlockWrite(Data,Buffer^[FontPos],2048);
      END ELSE BEGIN
        BlockWrite(Data,Buffer^[FontPos],4096);
      END;
      Close(Data);
    END;
    Dispose(Buffer);
  END;
END.