{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,R-,S-,V-,X+,M 16384,0,655360}
{ Labelverwaltung fr GBSIM }
UNIT LabTool;

INTERFACE

TYPE
  TStrMem  = ARRAY [0..$FFFE] OF Char;
  PStrMem  = ^TStrMem;
  TLabels = ARRAY [0..$3FFE] OF RECORD
              N,V : Word;
            END;
  PLabels = ^TLabels;

VAR
  StrMEM : PStrMem;
  StrLen : Word;
  LabMem : PLabels;
  LabNum : Word;

PROCEDURE AddLabel(N:String;V:Word);
FUNCTION Find_Value(N:String):LongInt;
FUNCTION Find_Name(V:Word):String;

IMPLEMENTATION

FUNCTION UpString(S:String):String;
VAR
  C:Byte;
BEGIN
  FOR C:=1 TO Length(S) DO S[C]:=UpCase(S[C]);
  UpString:=S;
END;

PROCEDURE AddLabel(N:String;V:Word);
BEGIN
  N:=UpString(N);
  LabMem^[LabNum].N:=StrLen;
  LabMem^[LabNum].V:=V;
  WHILE Length(N)>0 DO BEGIN
    StrMem^[StrLen]:=N[1];
    Delete(N,1,1);
    Inc(StrLen);
  END;
  StrMem^[StrLen]:=#0;
  Inc(StrLen);
  Inc(LabNum);
END;

FUNCTION Find_Value(N:String):LongInt;
VAR
  D:String;
  R,C:Word;
BEGIN
  Find_Value:=-1;
  N:=UpString(N);
  C:=0;
  WHILE C<LabNum DO BEGIN
    R:=LabMem^[C].N;
    D:='';
    WHILE StrMem^[R]<>#0 DO BEGIN
      D:=D+StrMem^[R];
      Inc(R);
    END;
    IF N=D THEN BEGIN
      Find_Value:=LabMem^[C].V;
      C:=LabNum;
    END ELSE Inc(C);
  END;
END;

FUNCTION Find_Name(V:Word):String;
VAR
  D:String;
  R,C:Word;
BEGIN
  D:='';
  C:=0;
  WHILE C<LabNum DO  BEGIN
    IF LabMem^[C].V=V THEN BEGIN
      R:=LabMem^[C].N;
      WHILE StrMem^[R]<>#0 DO BEGIN
        D:=D+Char(StrMem^[R]);
        Inc(R);
      END;
      C:=LabNum;
    END ELSE Inc(C);
  END;
  Find_Name:=D;
END;

BEGIN
  StrLen:=0;
  New(StrMem);
  LabNum:=0;
  New(LabMem);
END.