; ============================================================================
;  DECOMP.INC
; ============================================================================
;  This function decompresses data compressed with comp.c .
;  Input: hl = source; de = dest
; ============================================================================
decompress:             ldi     a,(hl)  ; load command
			or      a
			ret     z       ; exit, if last byte
			bit     7,a
			jp      nz,ds   ; string functions
			bit     6,a
			jp      nz,dw1
			; RLE byte
			and     63      ; calc counter
			inc     a
			ld      b,a
			ldi     a,(hl)
db1:                    ld      (de),a
			inc     de
			dec     b
			jp      nz,db1
			jp      decompress      ; next command
dw1:                    ; RLE word
			and     63
			inc     a
			ld      b,(hl)          ; load word into bc
			inc     hl
			ld      c,(hl)
			inc     hl
dw2:                    push    af
			ld      a,b             ; store word
			ld      (de),a
			inc     de
			ld      a,c
			ld      (de),a
			inc     de
			pop     af
			dec     a
			jp      nz,dw2
			jp      decompress        ; next command
ds:                     bit     6,a
			jp      nz,dc
			; string repeat
			and     63
			inc     a
			push    hl
			ld      c,(hl)
			inc     hl
			ld      b,(hl)
			ld      h,d
			ld      l,e
			add     hl,bc
			ld      b,a
dr1:                    ldi     a,(hl)
			ld      (de),a
			inc     de
			dec     b
			jp      nz,dr1
			pop     hl
			inc     hl
			inc     hl
			jp      decompress        ; next command
dc:                     ; string copy
			and     63
			inc     a
			ld      b,a
dc1:                    ldi     a,(hl)
			ld      (de),a
			inc     de
			dec     b
			jp      nz,dc1
			jp      decompress        ; next command
; ============================================================================

