#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <alloc.h>
#include <dos.h>

void EndIt(void);

FILE *handle;
FILE *handle2;
char filename1[13];
char filename2[13];
short far *planeptr;
short far *tmpptr;
short far *mapptr;
short far *mptr;
long filelength;
int paletteindex;

struct mapheader
{
    int  Version;
    int  Width;
    int  Height;
};

mapheader MapHeader;

int main(){

    clrscr();
    printf("WGT Map to Sega converter.\n");
EnterName:
    printf("\nEnter the name of map file (include extension)> ");
    scanf("%s",&filename1);
    if (filename1=="")
    {
        printf("Please enter a map file name.\n");
        goto  EnterName;
    }
EnterData:
    printf("\nEnter the name of data file to save (include extension)> ");
    scanf("%s",&filename2);
    if (filename2=="")
    {
        printf("Please enter a data file name.\n");
        goto  EnterData;
    }

EnterPaletteNumber:
    printf("\nEnter the Palette number for these tiles.> ");
    scanf("%i", &paletteindex);
    if (paletteindex<0 || paletteindex>3)
    {
        printf("Please enter a number between 0 and 3.\n");
        goto  EnterPaletteNumber;
    }

    handle=fopen(filename1,"rb");
    if (handle==NULL)
    {
        printf("%s does not exist. Please enter another map file name.\n",filename1);
        goto  EnterName;
    }
    handle2=fopen(filename2,"wb");

    if (handle2==NULL)
    {
        printf("Could not create %s. Please enter another data file name.\n",filename2);
        fclose(handle);
        goto  EnterData;
    }

    planeptr=(short *)farmalloc(32000);
    tmpptr=planeptr;

    mapptr=(short *)farmalloc(32000);
    mptr=mapptr;

    fread(&MapHeader,sizeof(mapheader),1,handle);

    fseek(handle,0,SEEK_END);
    filelength=ftell(handle)-sizeof(mapheader);
    rewind(handle);

    if (filelength>32000)
    {
        printf("Invalid Map File.\n");
        EndIt();
    }

    fseek(handle,sizeof(mapheader),SEEK_SET);
    fread(tmpptr,1,filelength,handle);
    fclose(handle);

    if ((MapHeader.Width != 32) || (MapHeader.Height != 32)) EndIt();

    for (int col = 0; col < 32; col++)
    {
        for (int row = 0; row < 32; row++)
        {
            unsigned short tile = *(tmpptr++);
            *mptr        = ((tile * 4)     << 8) | (paletteindex << 5);
            *(mptr + 64) = ((tile * 4 + 1) << 8) | (paletteindex << 5);
            *(mptr + 1)  = ((tile * 4 + 2) << 8) | (paletteindex << 5);
            *(mptr + 65) = ((tile * 4 + 3) << 8) | (paletteindex << 5);
            mptr += 2;
        }
        mptr +=64;
    }
    fwrite(mapptr, 1, 128 * 64,handle2);

    fclose(handle2);

    EndIt();
    return 1;
}

void EndIt(void)
{
    fclose(handle);
    fclose(handle2);
    farfree(planeptr);
    farfree(mapptr);
    exit(0);
}
