#ifndef __BMAPGFX__

#include <math.h>
#include "video.hpp"

// Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.


extern void Error(char *fmt, ...);

extern "C" {
extern long           _MinClipX,_MinClipY,_MaxClipX,_MaxClipY;
extern unsigned char *_RendBuffer;
}

extern int   SCREENWIDTH;
extern int   SCREENHEIGHT;
extern int   HALF_SCREEN_WIDTH;
extern int   HALF_SCREEN_HEIGHT;

typedef struct _2dpointyp {
    float x,y;
    int u,v;
} POINT2D;

class BITMAPGFXCLASS {
 
 private:
  
  POINT2D  Coords[4];
  unsigned char *Image;
  int MidX,MidY;           // holds mid-point of image.

  void ScaleBitMap(int x0,int y0,int x2,int y2,
                   int u0,int v0,int u2,int v2,
                   unsigned char *Buffer,unsigned char *Image);
			   
  void RotateBitMap(int x0,int y0,int x1,int y1,int x2,int y2,
                    int u0,int v0,int u1,int v1,int u2,int v2,
     	            unsigned char *Buffer,unsigned char *Image);
 public:

  BITMAPGFXCLASS(void);
  ~BITMAPGFXCLASS(void);

  void Create( ImageStats *Stats, unsigned char *bitmap );
  void Rotate( unsigned char *Buffer, double angle, float scale );
  void Scale( unsigned char *Buffer, float percentage );

};

#define __BMAPGFX__
#endif
