#ifndef __DEFINES__

// Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.

const int LEFT   = 1;
const int RIGHT  = 2;
const int BOTTOM = 4;
const int TOP    = 8;

const int KEYBOARD = 1;
const int JOYSTICK = 2;
const int MOUSE    = 3;

const int MCGA_320_200_256 = 1;
const int SVGA_640_480_256 = 2;

const int CULL_Z   = 1;
const int CULL_XYZ = 2;

const int TRUE   = 1;
const int FALSE  = 0;

const int SUCCESS = 1;
const int FAILURE = 0;

const int PARENT = 0;
const int CHILD  = 1;

const int VIEWDISTANCE = 200;
const float ASPECTRATIO  = 1.2;
const int VD_ASPECTRATIO = VIEWDISTANCE*ASPECTRATIO;

const int NoMorph                               = 0;
const int Morph                                 = 1;
const int NoTexture                             = 0;
const int Texture                               = 8;
const int Opaque                                = 0;
const int Transparent                           = 16;
const int NoShadow                              = 0;
const int Shadow                                = 32;
const int NoHaze                                = 0;
const int Haze                                  = 64;

const int Constant                              = 1;
const int Lambert                               = 2;
const int Gouraud                               = 3;
const int Phong                                 = 4;
const int WireFrame                             = 5;

const int Constant_Texture                      = 9;
const int Lambert_Texture                       = 10;
const int Gouraud_Texture                       = 11;
const int Phong_Texture                         = 12;
const int WireFrame_Texture                     = 13;             // just here for completeness.

const int Constant_Trans                        = 17;
const int Lambert_Trans                         = 18;
const int Gouraud_Trans                         = 19;
const int Phong_Trans                           = 20;
const int WireFrame_Trans                       = 21;

const int Constant_Texture_Trans                = 25;
const int Lambert_Texture_Trans                 = 26;
const int Gouraud_Texture_Trans                 = 27;
const int Phong_Texture_Trans                   = 28;
const int WireFrame_Texture_Trans               = 29;        

const int Constant_Shadow                       = 33;
const int Lambert_Shadow                        = 34;
const int Gouraud_Shadow                        = 35;
const int Phong_Shadow                          = 36;
const int WireFrame_Shadow                      = 37;

const int Constant_Texture_Shadow               = 41;    // do you find this starting to get insane?
const int Lambert_Texture_Shadow                = 42;
const int Gouraud_Texture_Shadow                = 43;
const int Phong_Texture_Shadow                  = 44;
const int WireFrame_Texture_Shadow              = 45;             // just here for completeness.

const int Constant_Trans_Shadow                 = 49;
const int Lambert_Trans_Shadow                  = 50;
const int Gouraud_Trans_Shadow                  = 51;
const int Phong_Trans_Shadow                    = 52;
const int WireFrame_Trans_Shadow                = 53;

const int Constant_Texture_Trans_Shadow         = 57;
const int Lambert_Texture_Trans_Shadow          = 58;
const int Gouraud_Texture_Trans_Shadow          = 59;
const int Phong_Texture_Trans_Shadow            = 60;
const int WireFrame_Texture_Trans_Shadow        = 61;        

                                             // NOTE: you can't have both
                                             // transparency and haze!
                                             
const int Constant_Haze                         = 65;
const int Lambert_Haze                          = 66;
const int Gouraud_Haze                          = 67;
const int Phong_Haze                            = 68;
const int WireFrame_Haze                        = 69;

const int Constant_Texture_Haze                 = 73;    // do you find this starting to get insane?
const int Lambert_Texture_Haze                  = 74;
const int Gouraud_Texture_Haze                  = 75;
const int Phong_Texture_Haze                    = 76;
const int WireFrame_Texture_Haze                = 77;             // just here for completeness.

const int Constant_Shadow_Haze                  = 97;       // this is getting
const int Lambert_Shadow_Haze                   = 98;       // way too crazy.
const int Gouraud_Shadow_Haze                   = 99;       // I'm outta here!
const int Phong_Shadow_Haze                     = 100;
const int WireFrame_Shadow_Haze                 = 101;       

const int Constant_Texture_Shadow_Haze          = 105;
const int Lambert_Texture_Shadow_Haze           = 106;
const int Gouraud_Texture_Shadow_Haze           = 107;
const int Phong_Texture_Shadow_Haze             = 108;
const int WireFrame_Texture_Shadow_Haze         = 109;

const int SHADES  = 63;
const int HALF_SHADES = (SHADES)/2;
const int AMBIENT = 10;
const int AMBIENTANGLE = 81*256;        // This is used for Phong shading. Angle where
                                        // cos (81)*NUM_SHADES = AMBIENT or 10. (fixed point 8).

const float Pi                 = 3.145926;
const float DEGREES_TO_RADIANS = Pi/(float)180;
const float RADIANS_TO_DEGREES = ( (float)180/Pi)*256;  // make it fixed point 8.

const int    SCAN_ANY         = 0;
const int    SCAN_ESC         = 1;
const int    SCAN_1           = 2;
const int    SCAN_2           = 3;
const int    SCAN_3           = 4;
const int    SCAN_4           = 5;
const int    SCAN_5           = 6;
const int    SCAN_6           = 7;
const int    SCAN_7           = 8;
const int    SCAN_8           = 9;
const int    SCAN_9           = 10;
const int    SCAN_0           = 11;
const int    SCAN_MINUS       = 12;
const int    SCAN_EQUAL       = 13;
const int    SCAN_BKSP        = 14;
const int    SCAN_TAB         = 15;
const int    SCAN_Q           = 16;
const int    SCAN_W           = 17;
const int    SCAN_E           = 18;
const int    SCAN_R           = 19;
const int    SCAN_T           = 20;
const int    SCAN_Y           = 21;
const int    SCAN_U           = 22;
const int    SCAN_I           = 23;
const int    SCAN_O           = 24;
const int    SCAN_P           = 25;
const int    SCAN_LSB         = 26;
const int    SCAN_RSB         = 27;
const int    SCAN_ENTER       = 28;
const int    SCAN_CTRL        = 29;
const int    SCAN_A           = 30;
const int    SCAN_S           = 31;
const int    SCAN_D           = 32;
const int    SCAN_F           = 33;
const int    SCAN_G           = 34;
const int    SCAN_H           = 35;
const int    SCAN_J           = 36;
const int    SCAN_K           = 37;
const int    SCAN_L           = 38;
const int    SCAN_SEMICOLON   = 39;
const int    SCAN_APOS        = 40;
const int    SCAN_TILDE       = 41;
const int    SCAN_LEFTSHFT    = 42;
const int    SCAN_BACKSLASH   = 43;
const int    SCAN_Z           = 44;
const int    SCAN_X           = 45;
const int    SCAN_C           = 46;
const int    SCAN_V           = 47;
const int    SCAN_B           = 48;
const int    SCAN_N           = 49;
const int    SCAN_M           = 50;
const int    SCAN_COMMA       = 51;
const int    SCAN_PERIOD      = 52;
const int    SCAN_SLASH       = 53;
const int    SCAN_RIGHTSHFT   = 54;
const int    SCAN_PRINTSCRN   = 55;
const int    SCAN_ALT         = 56;
const int    SCAN_SPACE       = 57;
const int    SCAN_CAPLOCK     = 58;
const int    SCAN_F1          = 59;
const int    SCAN_F2          = 60;
const int    SCAN_F3          = 61;
const int    SCAN_F4          = 62;
const int    SCAN_F5          = 63;
const int    SCAN_F6          = 64;
const int    SCAN_F7          = 65;
const int    SCAN_F8          = 66;
const int    SCAN_F9          = 67;
const int    SCAN_F10         = 68;
const int    SCAN_NUMLOCK     = 69;
const int    SCAN_SCROLLOCK   = 70;
const int    SCAN_HOME        = 71;
const int    SCAN_UP          = 72;
const int    SCAN_PGUP        = 73;
const int    SCAN_KEYPADMINUS = 74;
const int    SCAN_LEFT        = 75;
const int    SCAN_CENTER      = 76;
const int    SCAN_RIGHT       = 77;
const int    SCAN_KEYPADPLUS  = 78;
const int    SCAN_END         = 79;
const int    SCAN_DOWN        = 80;
const int    SCAN_PGDOWN      = 81;
const int    SCAN_INSERT      = 82;
const int    SCAN_DELETE      = 83;
const int    SCAN_F11         = 84;
const int    SCAN_F12         = 85;

#define __DEFINES__
#endif

