#ifndef __INPUT__

#include <string.h>
#include "defines.hpp"

// Copyright (c) 1996 by Kerrigan Burgess, all rights reserved.

extern void Error(char *fmt, ...);

const short   KEYBOARD_INT     = 0x09;
const short   MAKE_ESC         = 1;
const short   MAKE_1           = 2;
const short   MAKE_2           = 3;
const short   MAKE_3           = 4;
const short   MAKE_4           = 5;
const short   MAKE_5           = 6;
const short   MAKE_6           = 7;
const short   MAKE_7           = 8;
const short   MAKE_8           = 9;
const short   MAKE_9           = 10;
const short   MAKE_0           = 11;
const short   MAKE_MINUS       = 12;
const short   MAKE_EQUAL       = 13;
const short   MAKE_BKSP        = 14;
const short   MAKE_TAB         = 15;
const short   MAKE_Q           = 16;
const short   MAKE_W           = 17;
const short   MAKE_E           = 18;
const short   MAKE_R           = 19;
const short   MAKE_T           = 20;
const short   MAKE_Y           = 21;
const short   MAKE_U           = 22;
const short   MAKE_I           = 23;
const short   MAKE_O           = 24;
const short   MAKE_P           = 25;
const short   MAKE_LSB         = 26;
const short   MAKE_RSB         = 27;
const short   MAKE_ENTER       = 28;
const short   MAKE_CTRL        = 29;
const short   MAKE_A           = 30;
const short   MAKE_S           = 31;
const short   MAKE_D           = 32;
const short   MAKE_F           = 33;
const short   MAKE_G           = 34;
const short   MAKE_H           = 35;
const short   MAKE_J           = 36;
const short   MAKE_K           = 37;
const short   MAKE_L           = 38;
const short   MAKE_SEMICOLON   = 39;
const short   MAKE_APOS        = 40;
const short   MAKE_TILDE       = 41;
const short   MAKE_LEFTSHFT    = 42;
const short   MAKE_BACKSLASH   = 43;
const short   MAKE_Z           = 44;
const short   MAKE_X           = 45;
const short   MAKE_C           = 46;
const short   MAKE_V           = 47;
const short   MAKE_B           = 48;
const short   MAKE_N           = 49;
const short   MAKE_M           = 50;
const short   MAKE_COMMA       = 51;
const short   MAKE_PERIOD      = 52;
const short   MAKE_SLASH       = 53;
const short   MAKE_RIGHTSHFT   = 54;
const short   MAKE_PRINTSCRN   = 55;
const short   MAKE_ALT         = 56;
const short   MAKE_SPACE       = 57;
const short   MAKE_CAPLOCK     = 58;
const short   MAKE_F1          = 59;
const short   MAKE_F2          = 60;
const short   MAKE_F3          = 61;
const short   MAKE_F4          = 62;
const short   MAKE_F5          = 63;
const short   MAKE_F6          = 64;
const short   MAKE_F7          = 65;
const short   MAKE_F8          = 66;
const short   MAKE_F9          = 67;
const short   MAKE_F10         = 68;
const short   MAKE_NUMLOCK     = 69;
const short   MAKE_SCROLLOCK   = 70;
const short   MAKE_HOME        = 71;
const short   MAKE_UP          = 72;
const short   MAKE_PGUP        = 73;
const short   MAKE_KEYPADMINUS = 74;
const short   MAKE_LEFT        = 75;
const short   MAKE_CENTER      = 76;
const short   MAKE_RIGHT       = 77;
const short   MAKE_KEYPADPLUS  = 78;
const short   MAKE_END         = 79;
const short   MAKE_DOWN        = 80;
const short   MAKE_PGDOWN      = 81;
const short   MAKE_INSERT      = 82;
const short   MAKE_DELETE      = 83;
const short   MAKE_F11         = 87;
const short   MAKE_F12         = 88;

const short   BREAK_ESC         = 1+128;
const short   BREAK_1           = 2+128;
const short   BREAK_2           = 3+128;
const short   BREAK_3           = 4+128;
const short   BREAK_4           = 5+128;
const short   BREAK_5           = 6+128;
const short   BREAK_6           = 7+128;
const short   BREAK_7           = 8+128;
const short   BREAK_8           = 9+128;
const short   BREAK_9           = 10+128;
const short   BREAK_0           = 11+128;
const short   BREAK_MINUS       = 12+128;
const short   BREAK_EQUAL       = 13+128;
const short   BREAK_BKSP        = 14+128;
const short   BREAK_TAB         = 15+128;
const short   BREAK_Q           = 16+128;
const short   BREAK_W           = 17+128;
const short   BREAK_E           = 18+128;
const short   BREAK_R           = 19+128;
const short   BREAK_T           = 20+128;
const short   BREAK_Y           = 21+128;
const short   BREAK_U           = 22+128;
const short   BREAK_I           = 23+128;
const short   BREAK_O           = 24+128;
const short   BREAK_P           = 25+128;
const short   BREAK_LSB         = 26+128;
const short   BREAK_RSB         = 27+128;
const short   BREAK_ENTER       = 28+128;
const short   BREAK_CTRL        = 29+128;
const short   BREAK_A           = 30+128;
const short   BREAK_S           = 31+128;
const short   BREAK_D           = 32+128;
const short   BREAK_F           = 33+128;
const short   BREAK_G           = 34+128;
const short   BREAK_H           = 35+128;
const short   BREAK_J           = 36+128;
const short   BREAK_K           = 37+128;
const short   BREAK_L           = 38+128;
const short   BREAK_SEMICOLON   = 39+128;
const short   BREAK_APOS        = 40+128;
const short   BREAK_TILDE       = 41+128;
const short   BREAK_LEFTSHFT    = 42+128;
const short   BREAK_BACKSLASH   = 43+128;
const short   BREAK_Z           = 44+128;
const short   BREAK_X           = 45+128;
const short   BREAK_C           = 46+128;
const short   BREAK_V           = 47+128;
const short   BREAK_B           = 48+128;
const short   BREAK_N           = 49+128;
const short   BREAK_M           = 50+128;
const short   BREAK_COMMA       = 51+128;
const short   BREAK_PERIOD      = 52+128;
const short   BREAK_SLASH       = 53+128;
const short   BREAK_RIGHTSHFT   = 54+128;
const short   BREAK_PRINTSCRN   = 55+128;
const short   BREAK_ALT         = 56+128;
const short   BREAK_SPACE       = 57+128;
const short   BREAK_CAPLOCK     = 58+128;
const short   BREAK_F1          = 59+128;
const short   BREAK_F2          = 60+128;
const short   BREAK_F3          = 61+128;
const short   BREAK_F4          = 62+128;
const short   BREAK_F5          = 63+128;
const short   BREAK_F6          = 64+128;
const short   BREAK_F7          = 65+128;
const short   BREAK_F8          = 66+128;
const short   BREAK_F9          = 67+128;
const short   BREAK_F10         = 68+128;
const short   BREAK_NUMLOCK     = 69+128;
const short   BREAK_SCROLLOCK   = 70+128;
const short   BREAK_HOME        = 71+128;
const short   BREAK_UP          = 72+128;
const short   BREAK_PGUP        = 73+128;
const short   BREAK_KEYPADMINUS = 74+128;
const short   BREAK_LEFT        = 75+128;
const short   BREAK_CENTER      = 76+128;
const short   BREAK_RIGHT       = 77+128;
const short   BREAK_KEYPADPLUS  = 78+128;
const short   BREAK_END         = 79+128;
const short   BREAK_DOWN        = 80+128;
const short   BREAK_PGDOWN      = 81+128;
const short   BREAK_INSERT      = 82+128;
const short   BREAK_DELETE      = 83+128;
const short   BREAK_F11         = 87+128;
const short   BREAK_F12         = 88+128;
                            
void GetKeyCodes(void);
void InitKeyBoard(void);
void RestoreKeyBoard(void);
    
class INPUTCLASS {
  public:
    INPUTCLASS(void);
    virtual ~INPUTCLASS();
    virtual int Is_Key(const short key) = 0;
    virtual void ClearKeys(void) = 0;
};

class KEYBOARDCLASS: public INPUTCLASS {

  public:
    KEYBOARDCLASS(void);
    virtual ~KEYBOARDCLASS(void);
    int Is_Key(const short key);
    void ClearKeys(void);
};

class JoyStickClass {
    // to be implemented later.
};

class MouseClass {
    // to be implemented later.
};

#define __INPUT__
#endif

